﻿---
title: Kernel Object File Creation
description: This rule detects the creation of a Linux kernel object file (.ko) on a system. Threat actors may leverage Linux kernel object files to load a rootkit...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_kernel_object_file_creation
products:
  - Elastic Security
---

# Kernel Object File Creation
This rule detects the creation of a Linux kernel object file (.ko) on a system. Threat actors may leverage Linux kernel
object files to load a rootkit or other type of malware on a system providing them with complete control and the ability
to hide from security products.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.file-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kernel Object File Creation

Kernel object files (.ko) are loadable modules that extend the functionality of the Linux kernel, often used for adding drivers or system features. Adversaries exploit this by loading malicious modules, such as rootkits, to gain control and evade detection. The detection rule identifies suspicious .ko file creation, excluding benign paths, to flag potential threats while minimizing false positives.

### Possible investigation steps

- Review the file path of the created .ko file to determine if it is located in a suspicious or unusual directory that is not excluded by the rule, such as /var/tmp or /usr/local.
- Examine the process that created the .ko file by checking the process.executable and process.name fields to identify if it is a known legitimate process or potentially malicious.
- Investigate the parent process of the process that created the .ko file to understand the context of how the file was created and if it was initiated by a legitimate user action or a script.
- Check for any recent system changes or anomalies around the time of the .ko file creation, such as new user accounts, changes in system configurations, or other suspicious file activities.
- Look for any associated network activity from the host around the time of the .ko file creation to identify potential command and control communications or data exfiltration attempts.
- Correlate the alert with other security events or logs from the same host to identify any patterns or additional indicators of compromise that may suggest a broader attack campaign.


### False positive analysis

- Kernel updates and system maintenance activities can generate .ko files in legitimate scenarios. Users should monitor for these activities and consider excluding paths related to official update processes.
- Custom kernel module development by developers or system administrators may trigger this rule. Establish a process to whitelist known development environments or specific user accounts involved in module creation.
- Automated system recovery tools, such as those using mkinitramfs, may create .ko files. Ensure these paths are excluded as indicated in the rule to prevent unnecessary alerts.
- Snap package installations might involve .ko file creation. Exclude the /snap/ directory to avoid false positives from legitimate package installations.
- Backup and restoration processes using tools like cpio can lead to .ko file creation. Verify these processes and exclude them if they are part of routine system operations.


### Response and remediation

- Isolate the affected system from the network to prevent further spread or communication with potential command and control servers.
- Terminate any suspicious processes associated with the creation of the .ko file, especially those not originating from known benign paths.
- Remove the suspicious .ko file from the system to prevent it from being loaded into the kernel.
- Conduct a thorough scan of the system using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any additional malicious components.
- Review system logs and audit trails to identify any unauthorized access or changes made around the time of the .ko file creation.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if the threat is part of a larger attack campaign.
- Implement additional monitoring and alerting for similar activities, ensuring that any future attempts to create or load unauthorized .ko files are promptly detected and addressed.


## Rule Query

```kuery
event.category:file and host.os.type:linux and event.type:creation and file.extension:ko and
not (
  file.path:(
    /tmp/mkinitramfs* or /var/cache/uptrack/* or /var/tmp/dracut.* or /build/* or /var/lib/dkms/* or
    /mnt/Samsung/* or /var/tmp/portage/* or /tmp/user/0/mkinitramfs* or /var/tmp/supermin* or
    /mnt/img/storage/squashfs-root/* or /var/opt/eset/* or /var/tmp/mkinitramfs_* 
  ) or
  process.executable:(
    "/usr/local/v3net/suarez/bin/suarez" or "/sbin/dracut" or "/opt/traps/bin/pmd" or "/usr/bin/pacman" or
    "/usr/bin/containerd" or "/usr/sbin/dockerd" or "/usr/bin/dockerd" or /snap/* or
    "/usr/lib/dracut/dracut-initramfs-restore" or "/sbin/unsquashfs"
  ) or
  process.name:"cpio"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Boot or Logon Autostart Execution
- Id: T1547
- Reference URL: [[https://attack.mitre.org/techniques/T1547/](https://attack.mitre.org/techniques/T1547/)](https://attack.mitre.org/techniques/T1547/)
- Sub Technique:
  - Name: Kernel Modules and Extensions
- Id: T1547.006
- Reference URL: [[https://attack.mitre.org/techniques/T1547/006/](https://attack.mitre.org/techniques/T1547/006/)](https://attack.mitre.org/techniques/T1547/006/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Rootkit
- Id: T1014
- Reference URL: [[https://attack.mitre.org/techniques/T1014/](https://attack.mitre.org/techniques/T1014/)](https://attack.mitre.org/techniques/T1014/)