﻿---
title: Unusual D-Bus Daemon Child Process
description: This rule detects when an unusual child process is spawned from the dbus-daemon parent process. The dbus-daemon process is a message bus system that provides...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_dbus_unsual_daemon_parent_execution
products:
  - Elastic Security
---

# Unusual D-Bus Daemon Child Process
This rule detects when an unusual child process is spawned from the `dbus-daemon` parent process. The `dbus-daemon`
process is a message bus system that provides a way for applications to talk to each other. Attackers may abuse this
process to execute malicious code or escalate privileges.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*
- endgame-*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Privilege Escalation
- Tactic: Execution
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Unusual D-Bus Daemon Child Process

The D-Bus daemon is a crucial component in Linux environments, facilitating inter-process communication by allowing applications to exchange information. Adversaries may exploit this by spawning unauthorized child processes to execute malicious code or gain elevated privileges. The detection rule identifies anomalies by monitoring child processes of the D-Bus daemon, excluding known benign processes and paths, thus highlighting potential threats.

### Possible investigation steps

- Review the process details to identify the unusual child process spawned from the dbus-daemon, focusing on the process name and executable path to determine if it is known or potentially malicious.
- Examine the command-line arguments (process.args) of the unusual child process to understand its intended function and assess if it aligns with typical usage patterns.
- Investigate the parent process arguments (process.parent.args) to confirm whether the dbus-daemon was running in a session context or another mode that might explain the unusual child process.
- Check the process start time and correlate it with other system events or logs to identify any related activities or anomalies occurring around the same time.
- Look into the user context under which the unusual child process was executed to determine if it was initiated by a legitimate user or potentially compromised account.
- Search for any network connections or file modifications associated with the unusual child process to identify potential data exfiltration or lateral movement activities.


### False positive analysis

- Known benign processes such as gnome-keyring-daemon and abrt-dbus may trigger the rule. Users can exclude these processes by adding them to the exception list in the detection rule.
- Processes executed from common library paths like /usr/lib/ or /usr/local/lib/ are typically non-threatening. Users should review these paths and consider excluding them if they are consistently generating false positives.
- The dbus-daemon with the --session argument is generally safe. Users can ensure this argument is included in the exception criteria to prevent unnecessary alerts.
- Specific applications like software-properties-dbus and serviceHelper.py are known to be benign. Users should verify these applications' legitimacy in their environment and exclude them if they are frequently flagged.
- Regularly review and update the exception list to include any new benign processes or paths that are identified over time, ensuring the rule remains effective without generating excessive false positives.


### Response and remediation

- Immediately isolate the affected system from the network to prevent potential lateral movement by the adversary.
- Terminate any suspicious child processes spawned by the dbus-daemon that are not recognized as legitimate or necessary for system operations.
- Conduct a thorough review of the affected system's logs to identify any unauthorized access or changes made by the suspicious process.
- Restore any altered or compromised system files from a known good backup to ensure system integrity.
- Update and patch the affected system and any related software to close vulnerabilities that may have been exploited.
- Implement stricter access controls and monitoring on the dbus-daemon to prevent unauthorized process execution in the future.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems are affected.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action in ("exec", "exec_event", "start") and
process.parent.name == "dbus-daemon" and process.args_count > 1 and not (
  process.parent.args == "--session" or
  process.args in ("/usr/lib/software-properties/software-properties-dbus", "/usr/share/backintime/qt/serviceHelper.py") or
  process.name in ("dbus-daemon-launch-helper", "gnome-keyring-daemon", "abrt-dbus", "aptd", "usb-creator-helper") or
  process.executable like (
    "/usr/lib/*", "/usr/local/lib/*", "/usr/libexec/*", "/tmp/newroot/*", "/usr/sbin/setroubleshootd",
    "/usr/share/setroubleshoot/SetroubleshootPrivileged.py",
    "/var/lib/awx/.local/share/containers/storage/overlay/*/SetroubleshootPrivileged.py",
    "/home/*/.local/share/containers/storage/overlay/*/SetroubleshootPrivileged.py",
    "/bin/rpm", "/run/user/*/.bubblewrap/newroot/usr/libexec/rhsmd", "/opt/CrowdStrike/sandbox/usr/libexec/rhsmd",
    "/run/user/*/.bubblewrap/*/setroubleshootd"
  ) or
  (
    process.name like "python*" and
    process.args in (
      "/usr/share/usb-creator/usb-creator-helper", "/usr/sbin/aptd", "/usr/sbin/aptk", "/usr/bin/hp-pkservice",
      "/usr/libexec/language-selector/ls-dbus-backend"
    )
  ) or
  (process.name == "perl" and process.args like "/usr/share/system-tools-backends-*.pl") or
  ?process.working_directory like "/run/user/*/.bubblewrap/newroot/var/lib/gdm/"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create or Modify System Process
- Id: T1543
- Reference URL: [[https://attack.mitre.org/techniques/T1543/](https://attack.mitre.org/techniques/T1543/)](https://attack.mitre.org/techniques/T1543/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Create or Modify System Process
- Id: T1543
- Reference URL: [[https://attack.mitre.org/techniques/T1543/](https://attack.mitre.org/techniques/T1543/)](https://attack.mitre.org/techniques/T1543/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)