﻿---
title: Suspicious APT Package Manager Network Connection
description: Detects suspicious network events executed by the APT package manager, potentially indicating persistence through an APT backdoor. In Linux, APT (Advanced...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/persistence_apt_package_manager_netcon
products:
  - Elastic Security
---

# Suspicious APT Package Manager Network Connection
Detects suspicious network events executed by the APT package manager, potentially indicating persistence through an APT
backdoor. In Linux, APT (Advanced Package Tool) is a command-line utility used for handling packages on Debian-based
systems, providing functions for installing, updating, upgrading, and removing software along with managing package
repositories. Attackers can backdoor APT to gain persistence by injecting malicious code into scripts that APT runs,
thereby ensuring continued unauthorized access or control each time APT is used for package management.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network*
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/security-labs/sequel-on-persistence-mechanisms](https://www.elastic.co/security-labs/sequel-on-persistence-mechanisms)](https://www.elastic.co/security-labs/sequel-on-persistence-mechanisms)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Command and Control
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 9
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious APT Package Manager Network Connection

The APT package manager is crucial for managing software on Debian-based Linux systems. Adversaries may exploit APT by injecting malicious scripts, gaining persistence and control. The detection rule identifies suspicious APT-triggered shell executions followed by unusual network connections, flagging potential backdoor activities and unauthorized access attempts.

### Possible investigation steps

- Review the process details to confirm the parent process is indeed 'apt' and check the command-line arguments for any unusual or unauthorized scripts being executed.
- Investigate the network connection details, focusing on the destination IP address to determine if it is known to be malicious or associated with suspicious activity. Cross-reference with threat intelligence sources.
- Examine the process tree to identify any child processes spawned by the suspicious shell execution, which may provide further insight into the attacker's actions or intentions.
- Check the system logs for any other recent unusual activities or alerts that might correlate with the suspicious APT activity, such as unauthorized user logins or file modifications.
- Assess the system for any signs of persistence mechanisms that may have been established, such as cron jobs or modified startup scripts, which could indicate a backdoor installation.
- If possible, capture and analyze network traffic to and from the destination IP to understand the nature of the communication and identify any data exfiltration or command and control activities.


### False positive analysis

- Legitimate administrative scripts executed by APT may trigger the rule if they involve shell commands followed by network connections. Users can create exceptions for known scripts by specifying their paths or hashes.
- Automated system updates or package installations that involve network connections might be flagged. Users should monitor and whitelist these routine operations by identifying the specific processes and network destinations involved.
- Network connections to internal or trusted IP addresses not covered by the existing CIDR exclusions could be mistakenly flagged. Users can expand the CIDR list to include additional trusted IP ranges specific to their environment.
- Use of alternative shell environments or custom scripts that invoke APT with network operations may cause false positives. Users should document and exclude these specific use cases by process name or command-line arguments.
- Non-standard APT configurations or third-party tools that interact with APT and initiate network connections might be misidentified. Users should review and whitelist these tools by their executable paths or process names.


### Response and remediation

- Isolate the affected host immediately to prevent further unauthorized network connections and potential lateral movement within the network.
- Terminate any suspicious processes identified as being executed by the APT package manager, especially those involving shell executions.
- Conduct a thorough review of the APT configuration files and scripts to identify and remove any injected malicious code or unauthorized modifications.
- Revert any unauthorized changes to the system or software packages by restoring from a known good backup, ensuring the integrity of the system.
- Update all system packages and apply security patches to close any vulnerabilities that may have been exploited by the attacker.
- Monitor network traffic for any further suspicious connections or activities originating from the affected host, using enhanced logging and alerting mechanisms.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems have been compromised, ensuring a comprehensive response.


## Rule Query

```eql
sequence by host.id with maxspan=5s
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
   process.parent.name == "apt" and process.args == "-c" and
   process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish") and
    not process.args == "/usr/bin/apt-listbugs apt"
  ] by process.entity_id
  [network where host.os.type == "linux" and event.action == "connection_attempted" and event.type == "start" and not (
     destination.ip == null or destination.ip == "0.0.0.0" or cidrmatch(
     destination.ip, "10.0.0.0/8", "127.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12", "192.0.0.0/24", "192.0.0.0/29",
     "192.0.0.8/32", "192.0.0.9/32", "192.0.0.10/32", "192.0.0.170/32", "192.0.0.171/32", "192.0.2.0/24",
     "192.31.196.0/24", "192.52.193.0/24", "192.168.0.0/16", "192.88.99.0/24", "224.0.0.0/4", "100.64.0.0/10",
     "192.175.48.0/24","198.18.0.0/15", "198.51.100.0/24", "203.0.113.0/24", "240.0.0.0/4", "::1", "FE80::/10",
     "FF00::/8", "172.31.0.0/16"
     )
   ) and not process.executable == "/usr/bin/apt-listbugs"
  ] by process.parent.entity_id
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Create or Modify System Process
- Id: T1543
- Reference URL: [[https://attack.mitre.org/techniques/T1543/](https://attack.mitre.org/techniques/T1543/)](https://attack.mitre.org/techniques/T1543/)
- Technique:
  - Name: Event Triggered Execution
- Id: T1546
- Reference URL: [[https://attack.mitre.org/techniques/T1546/](https://attack.mitre.org/techniques/T1546/)](https://attack.mitre.org/techniques/T1546/)
- Sub Technique:
  - Name: Installer Packages
- Id: T1546.016
- Reference URL: [[https://attack.mitre.org/techniques/T1546/016/](https://attack.mitre.org/techniques/T1546/016/)](https://attack.mitre.org/techniques/T1546/016/)
- Technique:
  - Name: Hijack Execution Flow
- Id: T1574
- Reference URL: [[https://attack.mitre.org/techniques/T1574/](https://attack.mitre.org/techniques/T1574/)](https://attack.mitre.org/techniques/T1574/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)