﻿---
title: Remote File Creation in World Writeable Directory
description: This rule detects the creation of a file in a world-writeable directory through a service that is commonly used for file transfer. This behavior is often...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/lateral_movement_remote_file_creation_world_writeable_dir
products:
  - Elastic Security
---

# Remote File Creation in World Writeable Directory
This rule detects the creation of a file in a world-writeable directory through a service that is
commonly used for file transfer. This behavior is often associated with lateral movement and can
be an indicator of an attacker attempting to move laterally within a network.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.file*
- auditbeat-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Lateral Movement
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 5
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from one of the following integrations:
- Elastic Defend
- Auditbeat


### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


### Auditbeat Setup

Auditbeat is a lightweight shipper that you can install on your servers to audit the activities of users and processes on your systems. For example, you can use Auditbeat to collect and centralize audit events from the Linux Audit Framework. You can also use Auditbeat to detect changes to critical files, like binaries and configuration files, and identify potential security policy violations.

#### The following steps should be executed in order to add the Auditbeat on a Linux System:

- Elastic provides repositories available for APT and YUM-based distributions. Note that we provide binary packages, but no source packages.
- To install the APT and YUM repositories follow the setup instructions in this [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setup-repositories.html).
- To run Auditbeat on Docker follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-docker.html).
- To run Auditbeat on Kubernetes follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-kubernetes.html).
- For complete “Setup and Run Auditbeat” information refer to the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setting-up-and-running.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Remote File Creation in World Writeable Directory

In Linux environments, world-writeable directories like `/tmp` and `/var/tmp` are used for temporary file storage, accessible by all users. Adversaries exploit these directories to deposit malicious files via remote services such as SSH or FTP, facilitating lateral movement. The detection rule identifies file creation events in these directories by non-root users using common file transfer services, signaling potential unauthorized activity.

### Possible investigation steps

- Review the file creation event details, focusing on the file path to determine if it matches any known malicious patterns or if it is unusual for the environment.
- Identify the user associated with the file creation event by examining the user.id field, and verify if this user should have access to the affected directory.
- Investigate the process responsible for the file creation by analyzing the process.name field to determine if it aligns with expected usage patterns for the user and system.
- Check the source IP address and connection details related to the file transfer service used (e.g., SSH, FTP) to identify any suspicious or unauthorized access attempts.
- Correlate the event with other recent activities on the host to identify any patterns of lateral movement or other suspicious behavior.
- Review historical data for similar file creation events by the same user or process to assess if this is part of a recurring pattern or an isolated incident.


### False positive analysis

- Routine administrative tasks: System administrators often use file transfer services like scp or rsync to move files for legitimate purposes. To reduce false positives, create exceptions for known administrative accounts or specific file paths that are regularly used for maintenance.
- Automated scripts and cron jobs: Automated processes may create temporary files in world-writeable directories. Identify and whitelist these scripts or jobs by their process names or user accounts to prevent unnecessary alerts.
- Software updates and installations: Some software updates or installations may temporarily use world-writeable directories. Monitor and document these activities, and consider excluding specific update processes or package managers from the rule.
- Development and testing environments: Developers may use these directories for testing purposes. Establish a separate monitoring policy for development environments or exclude known developer accounts to minimize false positives.
- Backup operations: Backup tools might use temporary directories for staging files. Identify these tools and their typical behavior, and create exceptions based on their process names or user IDs.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further lateral movement by the adversary.
- Terminate any suspicious processes associated with file transfer services (e.g., scp, ssh, ftp) that are not part of legitimate user activity.
- Remove any unauthorized files created in world-writeable directories such as /tmp, /var/tmp, or /dev/shm to eliminate potential threats.
- Conduct a thorough review of user accounts and permissions, focusing on non-root users who have recently accessed the system, to identify any unauthorized access.
- Reset credentials for compromised or potentially compromised accounts to prevent further unauthorized access.
- Monitor network traffic for unusual patterns or connections to external IP addresses that may indicate ongoing or additional compromise attempts.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems have been affected, ensuring a coordinated response.


## Rule Query

```kuery
event.category:file and host.os.type:linux and event.action:creation and
process.name:(ftp or rsync or scp or sftp or sftp-server or ssh or sshd or vsftpd) and
file.path:((/dev/shm/* or /tmp* or /var/tmp*) and not (/tmp/ansible-tmp-* or /var/tmp/ansible-tmp-*)) and
not user.id:0
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Remote Services
- Id: T1021
- Reference URL: [[https://attack.mitre.org/techniques/T1021/](https://attack.mitre.org/techniques/T1021/)](https://attack.mitre.org/techniques/T1021/)
- Sub Technique:
  - Name: SSH
- Id: T1021.004
- Reference URL: [[https://attack.mitre.org/techniques/T1021/004/](https://attack.mitre.org/techniques/T1021/004/)](https://attack.mitre.org/techniques/T1021/004/)
- Technique:
  - Name: Lateral Tool Transfer
- Id: T1570
- Reference URL: [[https://attack.mitre.org/techniques/T1570/](https://attack.mitre.org/techniques/T1570/)](https://attack.mitre.org/techniques/T1570/)