﻿---
title: Kubeconfig File Creation or Modification
description: The kubeconfig file is a critical component in Kubernetes environments, containing configuration details for accessing and managing Kubernetes clusters...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/lateral_movement_kubeconfig_file_activity
products:
  - Elastic Security
---

# Kubeconfig File Creation or Modification
The kubeconfig file is a critical component in Kubernetes environments, containing configuration
details for accessing and managing Kubernetes clusters. Attackers may attempt to get access to,
create or modify kubeconfig files to gain unauthorized initial access to Kubernetes clusters or
move laterally within the cluster.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file*
- logs-cloud_defend.file*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://kubernetes-threat-matrix.redguard.ch/initial-access/kubeconfig-file/](https://kubernetes-threat-matrix.redguard.ch/initial-access/kubeconfig-file/)](https://kubernetes-threat-matrix.redguard.ch/initial-access/kubeconfig-file/)
- [[https://kubenomicon.com/Initial_access/Kubeconfig_file.html](https://kubenomicon.com/Initial_access/Kubeconfig_file.html)](https://kubenomicon.com/Initial_access/Kubeconfig_file.html)

**Tags**:
- Domain: Endpoint
- Domain: Container
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Lateral Movement
- Tactic: Defense Evasion
- Tactic: Initial Access
- Data Source: Elastic Defend
- Data Source: Elastic Defend for Containers
- Resources: Investigation Guide

**Version**: 103
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.

For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubeconfig File Creation or Modification

Kubeconfig files are essential in Kubernetes environments, storing configurations for cluster access and management. Adversaries may target these files to gain unauthorized access or move laterally within clusters. The detection rule identifies suspicious creation or modification of kubeconfig files, excluding legitimate processes like kubeadm and minikube, to flag potential threats and mitigate risks associated with unauthorized access.

### Possible investigation steps

- Review the alert details to identify the specific file path involved in the creation or modification event, focusing on paths like "/root/.kube/config" or "/etc/kubernetes/admin.conf".
- Examine the process responsible for the file creation or modification, ensuring it is not one of the excluded legitimate processes such as "kubeadm", "kubelet", "vcluster", or "minikube".
- Check the user account associated with the process to determine if it has legitimate access to modify kubeconfig files and assess if the activity aligns with typical user behavior.
- Investigate the timing of the event to see if it coincides with any scheduled maintenance or deployment activities that could explain the modification.
- Look for any related alerts or logs that might indicate lateral movement or unauthorized access attempts within the Kubernetes cluster.
- Assess the network activity from the host where the modification occurred to identify any suspicious connections or data transfers that could suggest unauthorized access or exfiltration.


### False positive analysis

- Legitimate administrative tools like kubeadm, kubelet, vcluster, and minikube may create or modify kubeconfig files as part of normal operations. Ensure these processes are excluded from triggering alerts by maintaining the exclusion list in the detection rule.
- Automated scripts or configuration management tools that use sed to modify kubeconfig files might be flagged. Consider adding specific script names or paths to the exclusion list if they are verified as non-threatening.
- User-initiated changes to kubeconfig files for legitimate access or configuration updates can trigger alerts. Implement a process to verify and document such changes, allowing for quick exclusion of known user actions.
- Regular updates or maintenance activities that involve kubeconfig file modifications should be documented and excluded from detection. Coordinate with the operations team to identify and whitelist these activities.
- Development environments where frequent kubeconfig changes occur, such as in testing or staging, may generate false positives. Establish a separate monitoring policy for these environments to reduce noise while maintaining security oversight.


### Response and remediation

- Immediately isolate the affected system to prevent further unauthorized access or lateral movement within the Kubernetes cluster.
- Revoke any potentially compromised credentials associated with the kubeconfig files and issue new credentials to ensure secure access.
- Conduct a thorough review of recent access logs and audit trails to identify any unauthorized access or suspicious activity related to the kubeconfig files.
- Restore the kubeconfig files from a known good backup to ensure the integrity of the configuration and access settings.
- Implement additional monitoring and alerting for any future modifications to kubeconfig files, focusing on processes not typically involved in legitimate changes.
- Escalate the incident to the security operations team for further investigation and to assess the potential impact on the broader Kubernetes environment.
- Review and update Kubernetes access policies to ensure they align with best practices for security and least privilege, reducing the risk of unauthorized access.


## Rule Query

```eql
file where host.os.type == "linux" and event.type != "deletion" and file.path like (
  "/root/.kube/config",
  "/home/*/.kube/config",
  "/etc/kubernetes/admin.conf",
  "/etc/kubernetes/super-admin.conf",
  "/etc/kubernetes/kubelet.conf",
  "/etc/kubernetes/controller-manager.conf",
  "/etc/kubernetes/scheduler.conf",
  "/var/lib/*/kubeconfig"
) and not (
  process.name in ("kubeadm", "kubelet", "vcluster", "minikube", "kind") or
  (process.name == "sed" and ?file.Ext.original.name like "sed*") or
  process.executable like (
    "/usr/local/bin/k3d", "/usr/local/aws-cli/*/dist/aws", "/usr/local/bin/ks", "/usr/local/bin/aws",
    "/usr/local/bin/kubectl"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Lateral Movement
- Id: TA0008
- Reference URL: [[https://attack.mitre.org/tactics/TA0008/](https://attack.mitre.org/tactics/TA0008/)](https://attack.mitre.org/tactics/TA0008/)
- Technique:
  - Name: Use Alternate Authentication Material
- Id: T1550
- Reference URL: [[https://attack.mitre.org/techniques/T1550/](https://attack.mitre.org/techniques/T1550/)](https://attack.mitre.org/techniques/T1550/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Use Alternate Authentication Material
- Id: T1550
- Reference URL: [[https://attack.mitre.org/techniques/T1550/](https://attack.mitre.org/techniques/T1550/)](https://attack.mitre.org/techniques/T1550/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)