﻿---
title: Potential Webshell Deployed via Apache Struts CVE-2023-50164 Exploitation
description: Identifies successful exploitation of CVE-2023-50164, a critical path traversal vulnerability in Apache Struts 2 file upload functionality. This high-fidelity...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/initial_access_apache_struts_cve_2023_50164_exploitation_to_webshell
products:
  - Elastic Security
---

# Potential Webshell Deployed via Apache Struts CVE-2023-50164 Exploitation
Identifies successful exploitation of CVE-2023-50164, a critical path traversal vulnerability in Apache Struts 2 file
upload functionality. This high-fidelity rule detects a specific attack sequence where a malicious multipart/form-data
POST request with WebKitFormBoundary is made to a Struts .action upload endpoint, immediately followed by the creation
of a JSP web shell file by a Java process in Tomcat's webapps directories. This correlated activity indicates active
exploitation resulting in remote code execution capability through unauthorized file upload and web shell deployment.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.*
- logs-network_traffic.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://nvd.nist.gov/vuln/detail/CVE-2023-50164](https://nvd.nist.gov/vuln/detail/CVE-2023-50164)](https://nvd.nist.gov/vuln/detail/CVE-2023-50164)
- [[https://www.trendmicro.com/en_us/research/23/l/decoding-cve-2023-50164--unveiling-the-apache-struts-file-upload.html](https://www.trendmicro.com/en_us/research/23/l/decoding-cve-2023-50164--unveiling-the-apache-struts-file-upload.html)](https://www.trendmicro.com/en_us/research/23/l/decoding-cve-2023-50164--unveiling-the-apache-struts-file-upload.html)
- [[https://github.com/snyk-labs/CVE-2023-50164-POC](https://github.com/snyk-labs/CVE-2023-50164-POC)](https://github.com/snyk-labs/CVE-2023-50164-POC)

**Tags**:
- Domain: Endpoint
- Domain: Web
- Domain: Network
- OS: Linux
- Use Case: Threat Detection
- Tactic: Initial Access
- Tactic: Persistence
- Data Source: Elastic Defend
- Data Source: Network Traffic
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from both Elastic Defend (for file events) and Network Packet Capture integrations (for HTTP traffic analysis).

### Network Packet Capture Integration Setup

**IMPORTANT**: This rule requires HTTP request body capture to be enabled in order to detect the multipart/form-data content containing WebKitFormBoundary indicators. The network traffic integration must be configured to capture HTTP request bodies for POST requests with `multipart/form-data` content type.

## Investigation guide


## Triage and analysis


### Investigating Potential Webshell Deployed via Apache Struts CVE-2023-50164 Exploitation

CVE-2023-50164 is a critical path traversal vulnerability in Apache Struts 2 that allows attackers to manipulate file upload parameters and write malicious files to arbitrary locations on the web server. This vulnerability affects the file upload feature and enables attackers to bypass security controls, upload JSP-based web shells, and achieve remote code execution. This detection rule identifies the complete attack chain by correlating suspicious file upload requests to Struts endpoints with the subsequent creation of JSP files in web-accessible directories, indicating successful exploitation.

### Possible investigation steps

- Review the source IP address of the HTTP POST request to determine if it originates from a known malicious source, VPN/proxy service, or unexpected geographic location that does not align with legitimate application usage patterns.
- Examine the complete HTTP request details including headers, user agent string, and the full request body content to identify indicators of exploit code, path traversal attempts, or malicious payloads embedded in the multipart form data.
- Investigate the created JSP file by examining its contents, file name, creation timestamp, and file permissions to determine if it contains web shell code, command execution capabilities, or other malicious functionality.
- Check for any subsequent process execution, network connections, or file system activities originating from the Java process after the JSP file creation, which may indicate that the web shell has been accessed and used by the attacker.
- Review web server access logs for requests to the newly created JSP file path to identify if the attacker has attempted to access or execute the web shell, and capture any command execution or data exfiltration attempts.
- Examine the affected Struts application logs and Tomcat catalina logs for additional context about the file upload request, error messages, or anomalous behavior that occurred during the exploitation attempt.
- Identify the version of Apache Struts 2 running on the affected server to confirm if it is vulnerable to CVE-2023-50164 (versions prior to 2.5.33 or 6.3.0.2 are affected).
- Search for additional suspicious file creations, modifications, or deletions in the webapps directories that may indicate the attacker attempted multiple exploitation attempts or deployed additional persistence mechanisms.


### False positive analysis

- Legitimate application deployments using multipart form uploads to Struts endpoints followed by JSP file creation are uncommon but possible in custom deployment workflows. Review the source IP, user identity, and timing against known deployment schedules and authorized deployment systems.
- Automated testing frameworks or security scanning tools that test file upload functionality may trigger this rule if they upload files to Struts endpoints. Identify and exclude known security testing tools or authorized penetration testing activities based on source IP or user agent patterns.
- Development or staging environments where developers frequently test file upload features may generate alerts. Consider creating exceptions for non-production environments or restricting the rule to production systems only.
- CI/CD pipelines that deploy applications via multipart form uploads could potentially match this pattern, though this is rare. Review the deployment process and create exceptions for known automated deployment systems if necessary.


### Response and remediation

- Immediately isolate the affected web server from the network to prevent further exploitation, lateral movement, or data exfiltration by the attacker.
- Identify and delete the malicious JSP web shell file from the web server, ensuring you preserve a copy for forensic analysis and evidence collection.
- Terminate any active web shell sessions by restarting the Java application server process and reviewing all active network connections for suspicious activity.
- Review web server access logs to identify all IP addresses that accessed the web shell and block those IP addresses at the network perimeter to prevent re-exploitation.
- Conduct a comprehensive scan of the affected server for additional web shells, backdoors, persistence mechanisms, or signs of lateral movement to other systems in the environment.
- Patch the Apache Struts 2 installation to version 2.5.33, 6.3.0.2, or higher to remediate the CVE-2023-50164 vulnerability and prevent future exploitation attempts.
- Review and harden file upload configurations in Struts applications, implement strict input validation, restrict file upload locations, and consider implementing web application firewall (WAF) rules to detect and block path traversal attempts.
- Reset credentials for any accounts or services running on the compromised server, as the attacker may have captured sensitive information or credentials through the web shell.
- Escalate the incident to the security operations center (SOC) and incident response team for comprehensive investigation, threat hunting, and to determine if additional systems were compromised.
- Conduct a post-incident review to identify gaps in detection, response, and vulnerability management processes, and implement improvements to prevent similar incidents in the future.


## Rule Query

```eql
sequence by agent.id with maxspan=10s
  [network where data_stream.dataset == "network_traffic.http" and
      http.request.method == "POST" and
      http.request.body.content like "*WebKitFormBoundary*" and
      url.path like~ "*upload*.action"]
  [file where event.dataset == "endpoint.events.file" and
      host.os.type == "linux" and
      event.action == "creation" and
      process.name == "java" and
      file.extension == "jsp" and
      file.path like "*/webapps/*" and
      not file.path like "*/WEB-INF/*" and
      not file.path like "*/META-INF/*" and
      not process.parent.name in ("apk", "apt", "apt-get", "dpkg", "yum", "rpm", "dnf", "systemd", "init")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Exploit Public-Facing Application
- Id: T1190
- Reference URL: [[https://attack.mitre.org/techniques/T1190/](https://attack.mitre.org/techniques/T1190/)](https://attack.mitre.org/techniques/T1190/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Server Software Component
- Id: T1505
- Reference URL: [[https://attack.mitre.org/techniques/T1505/](https://attack.mitre.org/techniques/T1505/)](https://attack.mitre.org/techniques/T1505/)
- Sub Technique:
  - Name: Web Shell
- Id: T1505.003
- Reference URL: [[https://attack.mitre.org/techniques/T1505/003/](https://attack.mitre.org/techniques/T1505/003/)](https://attack.mitre.org/techniques/T1505/003/)