﻿---
title: High Number of Process Terminations
description: This rule identifies a high number (10) of process terminations via pkill from the same host within a short time period. Rule type: threshold Rule indices:...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/impact_process_kill_threshold
products:
  - Elastic Security
---

# High Number of Process Terminations
This rule identifies a high number (10) of process terminations via pkill from the same host within a short time period.
**Rule type**: threshold
**Rule indices**:
- logs-endpoint.events.*
- endgame-*
- auditbeat-*
- logs-auditd_manager.auditd-*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Impact
- Resources: Investigation Guide
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Auditd Manager
- Data Source: Crowdstrike

**Version**: 116
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis


### Investigating High Number of Process Terminations

Attackers can kill processes for a variety of purposes. For example, they can kill process associated with business applications and databases to release the lock on files used by these applications so they may be encrypted,or stop security and backup solutions, etc.
This rule identifies a high number (10) of process terminations via pkill from the same host within a short time period.

#### Possible investigation steps

- Examine the entry point to the host and user in action via the Analyse View.
  - Identify the session entry leader and session user.
- Examine the contents of session leading to the process termination(s) via the Session View.
  - Examine the command execution pattern in the session, which may lead to suspricous activities.
- Examine the process killed during the malicious execution
  - Identify imment threat to the system from the process killed.
- Take necessary incident response actions to respawn necessary process.


### False positive analysis

- This activity is unlikely to happen legitimately. Benign true positives (B-TPs) can be added as exceptions if necessary.


### Response and remediation

- Initiate the incident response process based on the outcome of the triage.
- Isolate the involved host to prevent further destructive behavior, which is commonly associated with this activity.
- Investigate credential exposure on systems compromised or used by the attacker to ensure all compromised accounts are identified. Reset passwords for these accounts and other potentially compromised credentials, such as email, business systems, and web services.
- Reimage the host operating system or restore it to the operational state.
- If any other destructive action was identified on the host, it is recommended to prioritize the investigation and look for ransomware preparation and execution activities.
- Run a full antimalware scan. This may reveal additional artifacts left in the system, persistence mechanisms, and malware components.
- Determine the initial vector abused by the attacker and take action to prevent reinfection through the same vector.
- Using the incident response data, update logging and audit policies to improve the mean time to detect (MTTD) and the mean time to respond (MTTR).


## Rule Query

```kuery
event.category:process and host.os.type:linux and event.type:start and (
  (process.name:"pkill" and process.args:"-f") or
  (process.name:kill and process.args:"-9") or
  (process.name:killall)
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Service Stop
- Id: T1489
- Reference URL: [[https://attack.mitre.org/techniques/T1489/](https://attack.mitre.org/techniques/T1489/)](https://attack.mitre.org/techniques/T1489/)