﻿---
title: Potential Malware-Driven SSH Brute Force Attempt
description: This detection identifies a Linux host that has potentially been infected with malware and is being used to conduct brute-force attacks against external...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/impact_potential_bruteforce_malware_infection
products:
  - Elastic Security
---

# Potential Malware-Driven SSH Brute Force Attempt
This detection identifies a Linux host that has potentially been infected with malware and is being used to conduct
brute-force attacks against external systems over SSH (port 22 and common alternative SSH ports). The detection looks
for a high volume of outbound connection attempts to non-private IP addresses from a single process. A compromised host
may be part of a botnet or controlled by an attacker, attempting to gain unauthorized access to remote systems. This
behavior is commonly observed in SSH brute-force campaigns where malware hijacks vulnerable machines to expand its
attack surface. ESQL rules have limited fields available in its alert documents. Make sure to review the original
documents to aid in the investigation of this alert.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1h
**Searches indices from**: `now-61m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Impact
- Tactic: Execution
- Tactic: Command and Control
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 9
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Malware-Driven SSH Brute Force Attempt

SSH is a protocol used to securely access remote systems. Adversaries exploit it by deploying malware on compromised Linux hosts to perform brute-force attacks, attempting unauthorized access to other systems. The detection rule identifies such abuse by monitoring high volumes of outbound SSH connection attempts from a single process to external IPs, indicating potential malware activity.

### Possible investigation steps

- Review the process executable identified in the alert to determine if it is a legitimate application or potentially malicious. Check for known malware signatures or unusual file paths.
- Analyze the destination IP addresses involved in the connection attempts to identify if they are known malicious hosts or part of a larger attack infrastructure. Use threat intelligence sources to gather more information.
- Examine the host's recent activity logs to identify any unusual behavior or signs of compromise, such as unexpected process executions or changes in system configurations.
- Investigate the specific agent.id associated with the alert to determine if other alerts or suspicious activities have been reported from the same host, indicating a broader compromise.
- Check for any recent changes or updates to the host's software or configurations that could have introduced vulnerabilities exploited by the malware.
- Assess the network traffic patterns from the host to identify any other unusual outbound connections that may indicate additional malicious activity or data exfiltration attempts.


### False positive analysis

- High-volume legitimate SSH operations from a single process can trigger alerts. Exclude known safe processes or scripts that perform frequent SSH operations by adding them to an exception list.
- Automated backup or synchronization tools using SSH to connect to external servers may be misidentified. Identify these tools and exclude their process names or IP addresses from the detection rule.
- Development or testing environments where SSH connections are frequently initiated to external systems for legitimate purposes can cause false positives. Document these environments and adjust the rule to exclude their specific IP ranges or process identifiers.
- Security scanning tools that perform SSH checks on external systems might be flagged. Ensure these tools are recognized and their activities are excluded by specifying their process names or IP addresses in the rule exceptions.


### Response and remediation

- Isolate the affected Linux host from the network immediately to prevent further unauthorized access attempts and potential spread of malware to other systems.
- Terminate the suspicious process identified by the detection rule to stop ongoing brute-force attempts and reduce the risk of further compromise.
- Conduct a thorough malware scan on the isolated host using updated antivirus or endpoint detection and response (EDR) tools to identify and remove any malicious software.
- Review and reset credentials for any accounts that may have been targeted or compromised during the brute-force attempts to ensure account security.
- Apply security patches and updates to the affected host and any other vulnerable systems to mitigate known vulnerabilities that could be exploited by similar threats.
- Monitor network traffic for any signs of continued or new suspicious activity, particularly focusing on outbound SSH connections, to detect and respond to any further attempts promptly.
- Escalate the incident to the security operations center (SOC) or relevant security team for further investigation and to assess the potential impact on the broader network infrastructure.


## Rule Query

```esql
from logs-endpoint.events.network-* metadata _id, _index, _version

| mv_expand event.action 

| where
    host.os.type == "linux" and
    event.type == "start" and
    event.action == "connection_attempted" and
    destination.port in (22, 222, 2222, 10022, 2022, 2200, 62612, 8022) and
    not (
      cidr_match(
        destination.ip,
        "10.0.0.0/8", "127.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12",
        "192.0.0.0/24", "192.0.0.0/29", "192.0.0.8/32", "192.0.0.9/32",
        "192.0.0.10/32", "192.0.0.170/32", "192.0.0.171/32", "192.0.2.0/24",
        "192.31.196.0/24", "192.52.193.0/24", "192.168.0.0/16", "192.88.99.0/24",
        "224.0.0.0/4", "100.64.0.0/10", "192.175.48.0/24", "198.18.0.0/15",
        "198.51.100.0/24", "203.0.113.0/24", "240.0.0.0/4", "::1", "FE80::/10", "FF00::/8"
      ) or
      process.executable in (
        "/usr/bin/rclone", "/usr/bin/sss_ssh_knownhostsproxy", "/usr/sbin/sshd", "/usr/bin/ssh",
        "/usr/local/bin/php", "/usr/sbin/apache2", "/usr/sbin/nginx", "/usr/local/bin/argocd-repo-server",
        "/opt/nessus/sbin/nessusd", "/usr/local/bin/source-controller"
      ) or
      process.executable like "/usr/local/efax/*"
    )

| keep
    @timestamp,
    _id,
    _index,
    _version,
    host.os.type,
    event.type,
    event.action,
    destination.port,
    destination.ip,
    process.executable,
    agent.id,
    host.name,
    event.dataset,
    data_stream.namespace

| stats
    Esql.event_count = count(),
    Esql.agent_id_count_distinct = count_distinct(agent.id),
    Esql.host_name_values = values(host.name),
    Esql.agent_id_values = values(agent.id),
    Esql.event_dataset_values = values(event.dataset),
    Esql.data_stream_namespace_values = values(data_stream.namespace)

  by process.executable, destination.port

| where
    Esql.agent_id_count_distinct == 1 and
    Esql.event_count >= 100

// Extract unique values to ECS fields for alerts exclusion
| eval agent.id = mv_min(Esql.agent_id_values),
       host.name = mv_min(Esql.host_name_values)

| sort Esql.event_count asc

| keep Esql.*, agent.id, host.name, process.executable, destination.port
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Resource Hijacking
- Id: T1496
- Reference URL: [[https://attack.mitre.org/techniques/T1496/](https://attack.mitre.org/techniques/T1496/)](https://attack.mitre.org/techniques/T1496/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)