﻿---
title: Suspicious Data Encryption via OpenSSL Utility
description: Identifies when the openssl command-line utility is used to encrypt multiple files on a host within a short time window. Adversaries may encrypt data...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/impact_data_encrypted_via_openssl
products:
  - Elastic Security
---

# Suspicious Data Encryption via OpenSSL Utility
Identifies when the openssl command-line utility is used to encrypt multiple files on a host within a short time window.
Adversaries may encrypt data on a single or multiple systems in order to disrupt the availability of their target's data
and may attempt to hold the organization's data to ransom for the purposes of extortion.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.welivesecurity.com/2017/06/30/telebots-back-supply-chain-attacks-against-ukraine/](https://www.welivesecurity.com/2017/06/30/telebots-back-supply-chain-attacks-against-ukraine/)](https://www.welivesecurity.com/2017/06/30/telebots-back-supply-chain-attacks-against-ukraine/)
- [[https://www.trendmicro.com/en_us/research/21/f/bash-ransomware-darkradiation-targets-red-hat--and-debian-based-linux-distributions.html](https://www.trendmicro.com/en_us/research/21/f/bash-ransomware-darkradiation-targets-red-hat--and-debian-based-linux-distributions.html)](https://www.trendmicro.com/en_us/research/21/f/bash-ransomware-darkradiation-targets-red-hat--and-debian-based-linux-distributions.html)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Impact
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 11
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Data Encryption via OpenSSL Utility

OpenSSL is a widely-used command-line tool for secure data encryption and decryption. Adversaries may exploit OpenSSL to encrypt files rapidly across systems, aiming to disrupt data availability or demand ransom. The detection rule identifies suspicious OpenSSL usage by monitoring rapid file encryption activities, focusing on specific command patterns and excluding benign operations, thus highlighting potential malicious behavior.

### Possible investigation steps

- Review the process execution details on the host identified by host.id to confirm the presence of the openssl command and its associated arguments, ensuring they match the suspicious pattern specified in the query.
- Examine the user.name associated with the process to determine if the activity aligns with expected behavior for that user or if it indicates potential unauthorized access.
- Investigate the parent process identified by process.parent.entity_id to understand the context in which the openssl command was executed, checking for any unusual or unexpected parent processes.
- Check for any recent file modifications or creations on the host that coincide with the time window of the alert to assess the impact of the encryption activity.
- Look for additional related alerts or logs from the same host or user within a similar timeframe to identify any patterns or further suspicious activities that could indicate a broader attack.


### False positive analysis

- Legitimate batch encryption operations by system administrators or automated scripts may trigger the rule. To handle this, identify and whitelist specific scripts or user accounts that perform regular encryption tasks.
- Backup processes that use OpenSSL for encrypting data before storage can be mistaken for malicious activity. Exclude known backup processes by specifying their parent process names or paths.
- Developers or security teams testing encryption functionalities might inadvertently match the rule's criteria. Create exceptions for development environments or specific user accounts involved in testing.
- Automated data transfer services that encrypt files for secure transmission could be flagged. Identify these services and exclude their associated processes or user accounts from the rule.
- Regularly review and update the exclusion list to ensure it reflects current operational practices and does not inadvertently allow malicious activities.


### Response and remediation

- Immediately isolate the affected host from the network to prevent further spread of the encryption activity and potential lateral movement by the adversary.
- Terminate any suspicious OpenSSL processes identified on the host to halt ongoing encryption activities.
- Conduct a forensic analysis of the affected host to identify the scope of the encryption, including which files were encrypted and any potential data exfiltration.
- Restore encrypted files from the most recent clean backup to ensure data availability and integrity, ensuring that the backup is free from any malicious alterations.
- Change all credentials and keys that may have been exposed or used on the affected host to prevent unauthorized access.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are compromised.
- Implement enhanced monitoring and logging for OpenSSL usage across the network to detect and respond to similar threats more effectively in the future.


## Rule Query

```eql
sequence by host.id, user.name, process.parent.entity_id with maxspan=5s
  [ process where host.os.type == "linux" and event.action == "exec" and
    process.name == "openssl" and process.parent.name : ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "perl*", "php*", "python*", "xargs") and
    process.args == "-in" and process.args == "-out" and
    process.args in ("-k", "-K", "-kfile", "-pass", "-iv", "-md") and
    /* excluding base64 encoding options and including encryption password or key params */
    not process.args in ("-d", "-a", "-A", "-base64", "-none", "-nosalt") and
    not (process.parent.command_line == "bash -s" and process.args like "/root/recipes/recipes*")
  ] with runs=10
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Impact
- Id: TA0040
- Reference URL: [[https://attack.mitre.org/tactics/TA0040/](https://attack.mitre.org/tactics/TA0040/)](https://attack.mitre.org/tactics/TA0040/)
- Technique:
  - Name: Data Encrypted for Impact
- Id: T1486
- Reference URL: [[https://attack.mitre.org/techniques/T1486/](https://attack.mitre.org/techniques/T1486/)](https://attack.mitre.org/techniques/T1486/)