﻿---
title: Potential Data Exfiltration Through Curl
description: Detects the use of curl to upload an archived file to an internet server. Threat actors often will collect data on a system and compress it in an archive...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/exfiltration_potential_curl_data_exfiltration
products:
  - Elastic Security
---

# Potential Data Exfiltration Through Curl
Detects the use of curl to upload an archived file to an internet server. Threat actors often will collect data on a
system and compress it in an archive file before exfiltrating the file back to their C2 server for review. Many threat
actors have been seen utilizing curl to upload this archive file with the collected data to do this. Use of curl in this
way while not inherently malicious should be considered highly abnormal and suspicious activity.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*
- logs-crowdstrike.fdr*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://everything.curl.dev/usingcurl/uploads](https://everything.curl.dev/usingcurl/uploads)](https://everything.curl.dev/usingcurl/uploads)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Exfiltration
- Data Source: Elastic Defend
- Resources: Investigation Guide
- Data Source: Crowdstrike
- Data Source: SentinelOne

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Data Exfiltration Through Curl

Curl is a command-line tool used for transferring data with URLs, commonly employed for legitimate data exchange tasks. However, adversaries can exploit curl to exfiltrate sensitive data by uploading compressed files to remote servers. The detection rule identifies suspicious curl usage by monitoring for specific command patterns and arguments indicative of data uploads, flagging abnormal activities for further investigation.

### Possible investigation steps

- Review the process command line to confirm the presence of suspicious arguments such as "-F", "-T", "-d", or "--data*" and check for any compressed file extensions like .zip, .gz, or .tgz being uploaded to an external server.
- Investigate the parent process of the curl command to understand the context in which curl was executed, including the parent executable and its purpose.
- Examine network logs to identify the destination IP address or domain to which the data was being uploaded, and assess whether it is a known or suspicious entity.
- Check for any recent file creation or modification events on the host that match the compressed file types mentioned in the query, which could indicate data collection prior to exfiltration.
- Correlate this event with other security alerts or logs from the same host to identify any patterns of behavior that might suggest a broader compromise or data exfiltration attempt.


### False positive analysis

- Legitimate data transfers using curl for system backups or data synchronization can trigger the rule. To manage this, identify and whitelist specific processes or scripts that are known to perform these tasks regularly.
- Automated system updates or software installations that use curl to download and upload data might be flagged. Exclude these processes by verifying their source and adding them to an exception list if they are from trusted vendors.
- Internal data transfers within a secure network that use curl for efficiency can be mistaken for exfiltration. Monitor the destination IP addresses and exclude those that are internal or known safe endpoints.
- Developers or system administrators using curl for testing or development purposes may inadvertently trigger the rule. Educate these users on the potential alerts and establish a process for them to notify security teams of their activities to prevent unnecessary investigations.
- Scheduled tasks or cron jobs that use curl for routine data uploads should be reviewed and, if deemed safe, added to an exception list to avoid repeated false positives.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further data exfiltration and contain the threat.
- Terminate any suspicious curl processes identified by the detection rule to stop ongoing data transfers.
- Conduct a forensic analysis of the affected system to identify any additional malicious activities or compromised data.
- Change credentials and access keys that may have been exposed or used during the incident to prevent unauthorized access.
- Notify the security operations team and relevant stakeholders about the incident for awareness and further action.
- Review and update firewall and network security rules to block unauthorized outbound traffic, especially to suspicious or unknown external servers.
- Implement enhanced monitoring and logging for curl usage and similar data transfer tools to detect and respond to future exfiltration attempts promptly.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action in ("exec", "ProcessRollup2", "start") and process.name == "curl" and
?process.parent.executable != null and (process.args in ("-F", "-T", "-d") or process.args like ("--data*", "--form*")) and 
process.command_line like~ ("*@/*.zip*", "*@/*.gz*", "*@/*.tgz*", "*b64=@*", "*=<*") and
process.command_line like~ "*http*" and
not ?process.parent.executable == "/usr/share/untangle/bin/configuration-backup-upload-backup.sh"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Exfiltration
- Id: TA0010
- Reference URL: [[https://attack.mitre.org/tactics/TA0010/](https://attack.mitre.org/tactics/TA0010/)](https://attack.mitre.org/tactics/TA0010/)
- Technique:
  - Name: Exfiltration Over Alternative Protocol
- Id: T1048
- Reference URL: [[https://attack.mitre.org/techniques/T1048/](https://attack.mitre.org/techniques/T1048/)](https://attack.mitre.org/techniques/T1048/)