﻿---
title: Suspicious Named Pipe Creation
description: This rule detects the creation of unusually labeled named pipes (FIFOs) by the mkfifo command, which is often used by attackers to establish persistence...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_suspicious_mkfifo_execution
products:
  - Elastic Security
---

# Suspicious Named Pipe Creation
This rule detects the creation of unusually labeled named pipes (FIFOs) by the mkfifo command, which is often used by
attackers to establish persistence on a target system or to execute commands in the background. Through the new_terms
rule type, this rule can identify uncommon process command lines that may indicate the presence of a malicious
named pipe.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.process*
- logs-crowdstrike.fdr*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Tactic: Command and Control
- Data Source: Elastic Defend
- Resources: Investigation Guide
- Data Source: Crowdstrike
- Data Source: SentinelOne

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Named Pipe Creation

Named pipes, or FIFOs, are a form of inter-process communication in Linux environments, allowing data transfer between processes. Adversaries exploit this by creating named pipes in common directories like /tmp to stealthily execute commands or maintain persistence. The detection rule identifies unusual named pipe creation by monitoring the `mkfifo` command, especially when initiated by common shell processes, to flag potential malicious activity.

### Possible investigation steps

- Review the process command line arguments to identify the exact named pipe path and any associated commands or scripts that might have been executed using the named pipe.
- Investigate the parent process (bash, csh, dash, fish, ksh, sh, tcsh, or zsh) to determine the origin of the mkfifo command, checking for any unusual or unexpected scripts or commands that might have initiated it.
- Examine the user account associated with the mkfifo process to determine if it is a legitimate user or if the account might have been compromised.
- Check for any other suspicious activities or processes running under the same user account or originating from the same parent process to identify potential lateral movement or further malicious actions.
- Analyze the system logs around the time of the named pipe creation for any other indicators of compromise, such as unauthorized access attempts or unusual network connections.
- If possible, capture and review the contents of the named pipe to understand the data being transferred and assess whether it is part of a malicious operation.


### False positive analysis

- Named pipes created by legitimate applications for inter-process communication can trigger this rule. Users should identify and whitelist these applications by adding exceptions for specific process command lines that are known to be safe.
- System maintenance scripts or backup processes that use named pipes in directories like /tmp or /var/tmp may cause false positives. Review these scripts and exclude them from the rule if they are verified as non-malicious.
- Development environments or testing frameworks that frequently create and delete named pipes during their operations might be flagged. Users can mitigate this by excluding these environments from monitoring or by specifying exceptions for known development tools.
- Automated deployment tools that use named pipes for configuration management or orchestration tasks can also be a source of false positives. Ensure these tools are recognized and excluded from the rule to prevent unnecessary alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further malicious activity or lateral movement.
- Terminate any suspicious processes associated with the mkfifo command, especially those originating from common shell processes like bash or sh.
- Delete any named pipes created in directories such as /tmp, /dev/shm, or /var/tmp that do not follow expected naming conventions or are not part of legitimate applications.
- Conduct a thorough review of user accounts and permissions on the affected system to identify any unauthorized access or privilege escalation.
- Restore the system from a known good backup if any unauthorized changes or persistence mechanisms are detected.
- Implement additional monitoring on the affected system and network to detect any further attempts to create suspicious named pipes or execute unauthorized commands.
- Escalate the incident to the security operations team for further investigation and to determine if the threat is part of a larger attack campaign.


## Rule Query

```kuery
host.os.type:linux and event.category:process and event.type:start and event.action:(exec or ProcessRollup2 or start) and process.name:mkfifo and
process.parent.name:(bash or csh or dash or fish or ksh or sh or tcsh or zsh) and
process.args:((/dev/shm/* or /tmp/* or /var/tmp/*) and not (/*fifo* or /var/tmp/dracut* or /var/tmp/portage/* or /tmp/opencode_install*.trace))
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)