﻿---
title: Potential Reverse Shell via UDP
description: This detection rule identifies suspicious network traffic patterns associated with UDP reverse shell activity. This activity consists of a sample of an...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_shell_via_udp_cli_utility_linux
products:
  - Elastic Security
---

# Potential Reverse Shell via UDP
This detection rule identifies suspicious network traffic patterns associated with UDP reverse shell activity. This
activity consists of a sample of an execve, socket and connect syscall executed by the same process, where the
auditd.data.a0-1 indicate a UDP connection, ending with an egress connection event. An attacker may establish a Linux
UDP reverse shell to bypass traditional firewall restrictions and gain remote access to a target system covertly.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- logs-auditd_manager.auditd-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/swisskyrepo/PayloadsAllTheThings/blob/master/Methodology%20and%20Resources/Reverse%20Shell%20Cheatsheet.md](https://github.com/swisskyrepo/PayloadsAllTheThings/blob/master/Methodology%20and%20Resources/Reverse%20Shell%20Cheatsheet.md)](https://github.com/swisskyrepo/PayloadsAllTheThings/blob/master/Methodology%20and%20Resources/Reverse%20Shell%20Cheatsheet.md)
- [[https://www.elastic.co/security-labs/primer-on-persistence-mechanisms](https://www.elastic.co/security-labs/primer-on-persistence-mechanisms)](https://www.elastic.co/security-labs/primer-on-persistence-mechanisms)
- [[https://www.elastic.co/security-labs/linux-detection-engineering-with-auditd](https://www.elastic.co/security-labs/linux-detection-engineering-with-auditd)](https://www.elastic.co/security-labs/linux-detection-engineering-with-auditd)

**Tags**:
- Data Source: Auditd Manager
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Resources: Investigation Guide

**Version**: 11
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from one of the following integrations:
- Auditbeat
- Auditd Manager


### Auditbeat Setup

Auditbeat is a lightweight shipper that you can install on your servers to audit the activities of users and processes on your systems. For example, you can use Auditbeat to collect and centralize audit events from the Linux Audit Framework. You can also use Auditbeat to detect changes to critical files, like binaries and configuration files, and identify potential security policy violations.

#### The following steps should be executed in order to add the Auditbeat on a Linux System:

- Elastic provides repositories available for APT and YUM-based distributions. Note that we provide binary packages, but no source packages.
- To install the APT and YUM repositories follow the setup instructions in this [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setup-repositories.html).
- To run Auditbeat on Docker follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-docker.html).
- To run Auditbeat on Kubernetes follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-kubernetes.html).
- For complete “Setup and Run Auditbeat” information refer to the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setting-up-and-running.html).


### Auditd Manager Integration Setup

The Auditd Manager Integration receives audit events from the Linux Audit Framework which is a part of the Linux kernel.
Auditd Manager provides a user-friendly interface and automation capabilities for configuring and monitoring system auditing through the auditd daemon. With `auditd_manager`, administrators can easily define audit rules, track system events, and generate comprehensive audit reports, improving overall security and compliance in the system.

#### The following steps should be executed in order to add the Elastic Agent System integration "auditd_manager" on a Linux System:

- Go to the Kibana home page and click “Add integrations”.
- In the query bar, search for “Auditd Manager” and select the integration to see more details about it.
- Click “Add Auditd Manager”.
- Configure the integration name and optionally add a description.
- Review optional and advanced settings accordingly.
- Add the newly installed “auditd manager” to an existing or a new agent policy, and deploy the agent on a Linux system from which auditd log files are desirable.
- Click “Save and Continue”.
- For more details on the integration refer to the [helper guide](https://docs.elastic.co/integrations/auditd_manager).


#### Rule Specific Setup Note

Auditd Manager subscribes to the kernel and receives events as they occur without any additional configuration.
However, if more advanced configuration is required to detect specific behavior, audit rules can be added to the integration in either the "audit rules" configuration box or the "auditd rule files" box by specifying a file to read the audit rules from.
- For this detection rule no additional audit rules are required to be added to the integration.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Reverse Shell via UDP

Reverse shells over UDP can be exploited by attackers to bypass firewalls and gain unauthorized access to systems. This technique leverages UDP's connectionless nature, making it harder to detect. Adversaries may use scripting languages or network tools to initiate these connections. The detection rule identifies suspicious processes executing network-related syscalls and egress connections, flagging potential reverse shell activity.

### Possible investigation steps

- Review the process details such as process.pid, process.parent.pid, and process.name to identify the specific process that triggered the alert and its parent process.
- Examine the command line arguments and environment variables associated with the suspicious process to understand its intended function and origin.
- Check the network connection details, including destination.ip and network.direction, to determine the external entity the process attempted to connect to and assess if it is a known malicious IP or domain.
- Investigate the user account associated with the process to determine if it has been compromised or if there are any signs of unauthorized access.
- Analyze historical logs for any previous instances of similar process executions or network connections to identify patterns or repeated attempts.
- Correlate the alert with other security events or alerts from the same host.id to gather additional context and assess the scope of potential compromise.


### False positive analysis

- Legitimate administrative scripts or tools may trigger the rule if they use UDP for valid network operations. Users can create exceptions for specific scripts or processes that are known to perform routine administrative tasks.
- Automated monitoring or network management tools that use UDP for health checks or status updates might be flagged. Identify these tools and exclude their process names or network patterns from the rule.
- Development or testing environments where developers frequently use scripting languages or network tools for legitimate purposes can cause false positives. Consider excluding specific host IDs or process names associated with these environments.
- Custom applications that use UDP for communication, especially if they are developed in-house, may be mistakenly identified. Review these applications and whitelist their process names or network behaviors if they are verified as safe.
- Network scanning or diagnostic tools that use UDP for troubleshooting can be misinterpreted as malicious. Ensure these tools are recognized and excluded from the detection rule if they are part of regular network maintenance activities.


### Response and remediation

- Immediately isolate the affected host from the network to prevent further unauthorized access or data exfiltration.
- Terminate any suspicious processes identified by the detection rule, particularly those associated with known reverse shell tools or scripting languages.
- Conduct a forensic analysis of the affected system to identify any additional indicators of compromise, such as unauthorized user accounts or modified system files.
- Review and update firewall rules to block outbound UDP traffic from unauthorized applications or processes, ensuring legitimate traffic is not disrupted.
- Reset credentials for any accounts accessed from the affected host, especially if they have administrative privileges.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if other systems may be affected.
- Implement enhanced monitoring and logging for similar suspicious activities, focusing on the execution of network-related syscalls and egress connections from scripting languages or network tools.


## Rule Query

```eql
sample by host.id, process.pid, process.parent.pid
  [process where host.os.type == "linux" and event.type == "start" and event.action == "executed" and process.name : (
    "bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "perl", "python*", "nc", "ncat", "netcat", "php*",
    "ruby", "openssl", "awk", "telnet", "lua*", "socat"
    ) and
    not process.args in ("/var/www/MISP/app/Console/cake", "/var/www/MISP/app", "/usr/local/bin/wp")]
  [process where host.os.type == "linux" and auditd.data.syscall == "socket" and process.name : (
    "bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "perl", "python*", "nc", "ncat", "netcat", "php*",
    "ruby", "openssl", "awk", "telnet", "lua*", "socat"
    ) and auditd.data.a1 == "2"]
  [network where host.os.type == "linux" and event.type == "start" and event.action == "connected-to" and
   process.name : (
    "bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "perl", "python*", "nc", "ncat", "netcat", "php*",
    "ruby", "openssl", "awk", "telnet", "lua*", "socat"
    ) and network.direction == "egress" and destination.ip != null and
   not cidrmatch(destination.ip, "127.0.0.0/8", "169.254.0.0/16", "224.0.0.0/4", "::1")]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Application Layer Protocol
- Id: T1071
- Reference URL: [[https://attack.mitre.org/techniques/T1071/](https://attack.mitre.org/techniques/T1071/)](https://attack.mitre.org/techniques/T1071/)