﻿---
title: Kubectl Apply Pod from URL
description: This rule detects the execution of the "kubectl apply" command with a URL argument. This command is often used to apply configurations or deploy resources...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_kubectl_apply_pod_from_url
products:
  - Elastic Security
---

# Kubectl Apply Pod from URL
This rule detects the execution of the "kubectl apply" command with a URL argument. This command is often used to
apply configurations or deploy resources in a Kubernetes cluster. Attackers may use this command to deploy malicious
pods or modify existing ones, potentially leading to unauthorized access or data exfiltration.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*
- logs-auditd_manager.auditd-*
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Data Source: Auditd Manager
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Data Source: Elastic Defend for Containers
- Resources: Investigation Guide

**Version**: 102
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubectl Apply Pod from URL

Kubectl is a command-line tool for managing Kubernetes clusters, allowing users to deploy and manage applications. Adversaries may exploit the 'kubectl apply' command with a URL to deploy malicious configurations or pods, potentially compromising the cluster. The detection rule identifies such activities by monitoring for the execution of 'kubectl apply' with URL arguments, flagging potential unauthorized deployments.

### Possible investigation steps

- Review the process execution details to confirm the presence of 'kubectl apply' with a URL argument, ensuring the command matches the query criteria.
- Identify the source IP address or hostname from which the 'kubectl apply' command was executed to determine if it originates from a known or trusted source.
- Check the URL used in the 'kubectl apply' command to assess its legitimacy and whether it points to a trusted or suspicious source.
- Investigate the user account associated with the execution of the command to verify if it has the necessary permissions and if the activity aligns with expected behavior.
- Examine the Kubernetes cluster logs for any recent changes or deployments that correspond with the time of the alert to identify any unauthorized modifications or deployments.
- Cross-reference the alert with other security tools or logs, such as network traffic analysis, to detect any related suspicious activities or data exfiltration attempts.


### False positive analysis

- Routine administrative tasks: Regular use of 'kubectl apply' with URLs for legitimate configuration updates or deployments can trigger alerts. To manage this, create exceptions for known and trusted URLs used by administrators.
- Automated deployment scripts: Continuous integration/continuous deployment (CI/CD) pipelines often use 'kubectl apply' with URLs to automate deployments. Identify and exclude these scripts by their specific process arguments or originating IP addresses.
- Monitoring and logging tools: Some monitoring solutions may use 'kubectl apply' with URLs as part of their normal operations. Review and whitelist these tools by verifying their source and purpose.
- Internal development environments: Developers may frequently use 'kubectl apply' with URLs in test environments. Establish a separate rule set or exceptions for these environments to reduce noise while maintaining security in production clusters.


### Response and remediation

- Immediately isolate the affected Kubernetes cluster to prevent further unauthorized deployments or access. This can be done by restricting network access or disabling external API access temporarily.
- Review the specific pod or configuration deployed using the 'kubectl apply' command with a URL. Identify any malicious or unauthorized changes and remove them from the cluster.
- Conduct a thorough audit of the cluster's current state to identify any other unauthorized deployments or configurations that may have been applied.
- Revoke any compromised credentials or access tokens that may have been used to execute the unauthorized 'kubectl apply' command. Ensure that all access keys and tokens are rotated.
- Escalate the incident to the security operations team for further investigation and to determine the root cause of the breach. This may involve analyzing logs and network traffic to trace the source of the attack.
- Implement network policies and role-based access controls (RBAC) to limit the ability to apply configurations from external URLs, ensuring only trusted sources are allowed.
- Enhance monitoring and alerting for similar activities by integrating with security information and event management (SIEM) systems to detect and respond to future threats promptly.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
event.action in ("exec", "exec_event", "start", "ProcessRollup2", "process_started", "executed") and
process.name == "kubectl" and process.args == "apply" and
process.args like ("http://*", "https://*") and
not process.args like~ ("*download.elastic.co*", "*github.com/kubernetes-sigs/*")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Deploy Container
- Id: T1610
- Reference URL: [[https://attack.mitre.org/techniques/T1610/](https://attack.mitre.org/techniques/T1610/)](https://attack.mitre.org/techniques/T1610/)
- Technique:
  - Name: Container Administration Command
- Id: T1609
- Reference URL: [[https://attack.mitre.org/techniques/T1609/](https://attack.mitre.org/techniques/T1609/)](https://attack.mitre.org/techniques/T1609/)