﻿---
title: Egress Connection from Entrypoint in Container
description: This rule identifies a sequence of events where a process named "entrypoint.sh" is started in a container, followed by a network connection attempt. This...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/execution_egress_connection_from_entrypoint_in_container
products:
  - Elastic Security
---

# Egress Connection from Entrypoint in Container
This rule identifies a sequence of events where a process named "entrypoint.sh" is started in a container, followed by a
network connection attempt. This sequence indicates a potential egress connection from an entrypoint in a container. An
entrypoint is a command or script specified in the Dockerfile and executed when the container starts. Attackers can use
this technique to establish a foothold in the environment, escape from a container to the host, or establish persistence.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.network*
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Execution
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Egress Connection from Entrypoint in Container

Containers, often used for deploying applications, start with an entrypoint script that initializes the environment. Adversaries may exploit this by embedding malicious commands to initiate unauthorized network connections, potentially breaching security boundaries. The detection rule monitors for processes named `entrypoint.sh` followed by suspicious network activity, flagging attempts to connect to external IPs, thus identifying potential threats.

### Possible investigation steps

- Review the process details for the `entrypoint.sh` script execution, focusing on the `process.entity_id` and `host.id` to understand the context of the container where the script was executed.
- Examine the network connection attempt details, particularly the `destination.ip`, to determine if the IP address is known to be malicious or associated with suspicious activity.
- Check the container's Dockerfile or image configuration to verify if the `entrypoint.sh` script is expected and whether it contains any unauthorized modifications or additions.
- Investigate the parent process of the network connection attempt using `process.parent.entity_id` to identify if there are any other suspicious processes or activities linked to the same parent.
- Correlate the event with other logs or alerts from the same `host.id` to identify any additional indicators of compromise or related suspicious activities within the same timeframe.


### False positive analysis

- Legitimate application updates or installations may trigger the rule if they involve network connections from the entrypoint script. To handle this, identify and whitelist specific applications or update processes that are known to perform such actions.
- Automated configuration management tools might execute scripts that initiate network connections as part of their normal operations. Exclude these tools by specifying their process names or parent entity IDs in the rule exceptions.
- Containers designed to perform network diagnostics or monitoring could naturally attempt connections to external IPs. Review and exclude these containers by their image names or specific entrypoint scripts.
- Development or testing environments often run scripts that connect to external services for integration testing. Consider excluding these environments by tagging them appropriately and adjusting the rule to ignore these tags.
- Scheduled maintenance scripts that run periodically and require network access might be flagged. Document these scripts and create exceptions based on their execution schedule or specific network destinations.


### Response and remediation

- Immediately isolate the affected container to prevent further unauthorized network connections. This can be done by stopping the container or disconnecting it from the network.
- Conduct a thorough review of the `entrypoint.sh` script within the container to identify and remove any malicious commands or scripts that may have been injected.
- Analyze the network traffic logs to identify any external IP addresses that the container attempted to connect to. Block these IPs at the firewall level to prevent future connections.
- Check for any signs of lateral movement or attempts to escape the container to the host system. If detected, escalate to the security team for a comprehensive investigation.
- Restore the container from a known good backup if available, ensuring that the restored version is free from any malicious modifications.
- Implement additional monitoring on the affected host and container environment to detect any similar suspicious activities in the future.
- Report the incident to the appropriate internal security team or incident response team for further analysis and to update threat intelligence databases.


## Rule Query

```eql
sequence by host.id with maxspan=3s
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
   process.entry_leader.entry_meta.type == "container" and process.name == "entrypoint.sh"] by process.entity_id
  [network where event.type == "start" and event.action == "connection_attempted" and process.executable != null and
   not (
     destination.ip == null or destination.ip == "0.0.0.0" or cidrmatch(
       destination.ip, "10.0.0.0/8", "127.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12", "192.0.0.0/24", "192.0.0.0/29",
       "192.0.0.8/32", "192.0.0.9/32", "192.0.0.10/32", "192.0.0.170/32", "192.0.0.171/32", "192.0.2.0/24",
       "192.31.196.0/24", "192.52.193.0/24", "192.168.0.0/16", "192.88.99.0/24", "224.0.0.0/4", "100.64.0.0/10",
       "192.175.48.0/24","198.18.0.0/15", "198.51.100.0/24", "203.0.113.0/24", "240.0.0.0/4", "::1", "FE80::/10",
       "FF00::/8", "172.31.0.0/16"
       ) or
    // Excluding vast majority of noise
    (process.name like ("python*", "pip*") and destination.port == 443)
    )] by process.parent.entity_id
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Escape to Host
- Id: T1611
- Reference URL: [[https://attack.mitre.org/techniques/T1611/](https://attack.mitre.org/techniques/T1611/)](https://attack.mitre.org/techniques/T1611/)