﻿---
title: Yum/DNF Plugin Status Discovery
description: This rule detects the execution of the grep command with the plugins argument on Linux systems. This command is used to search for YUM/DNF configurations...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_yum_dnf_plugin_detection
products:
  - Elastic Security
---

# Yum/DNF Plugin Status Discovery
This rule detects the execution of the `grep` command with the `plugins` argument on Linux systems. This command is used
to search for YUM/DNF configurations and/or plugins with an enabled state. This behavior may indicate an attacker is
attempting to establish persistence in a YUM or DNF plugin.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*
- logs-auditd_manager.auditd-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/rapid7/metasploit-framework/blob/master/modules/exploits/linux/local/yum_package_manager_persistence.rb](https://github.com/rapid7/metasploit-framework/blob/master/modules/exploits/linux/local/yum_package_manager_persistence.rb)](https://github.com/rapid7/metasploit-framework/blob/master/modules/exploits/linux/local/yum_package_manager_persistence.rb)
- [[https://pwnshift.github.io/2020/10/01/persistence.html](https://pwnshift.github.io/2020/10/01/persistence.html)](https://pwnshift.github.io/2020/10/01/persistence.html)
- [[https://www.elastic.co/security-labs/sequel-on-persistence-mechanisms](https://www.elastic.co/security-labs/sequel-on-persistence-mechanisms)](https://www.elastic.co/security-labs/sequel-on-persistence-mechanisms)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Data Source: Auditd Manager
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 107
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Yum/DNF Plugin Status Discovery

Yum and DNF are package managers for Linux, managing software installations and updates. They support plugins to extend functionality, which can be targeted by attackers to maintain persistence. Adversaries may use commands to identify active plugins, potentially altering them for malicious purposes. The detection rule identifies suspicious use of the `grep` command to search for plugin configurations, signaling possible reconnaissance or tampering attempts.

### Possible investigation steps

- Review the process execution details to confirm the presence of the `grep` command with arguments related to plugin configurations, such as `/etc/yum.conf` or `/etc/dnf/dnf.conf`, to verify the alert's accuracy.
- Examine the user account associated with the process execution to determine if it is a legitimate user or potentially compromised account.
- Check the system's command history for any preceding or subsequent commands executed by the same user to identify potential patterns or further suspicious activity.
- Investigate any recent changes to the plugin configuration files located in directories like `/etc/yum/pluginconf.d/` or `/etc/dnf/plugins/` to detect unauthorized modifications.
- Correlate the alert with other security events or logs from the same host to identify any additional indicators of compromise or related malicious activity.


### False positive analysis

- System administrators or automated scripts may use the grep command to verify plugin configurations during routine maintenance. To handle this, create exceptions for known administrative scripts or user accounts that regularly perform these checks.
- Security audits or compliance checks might involve scanning for plugin configurations to ensure they are correctly set up. Exclude these activities by identifying and whitelisting the specific processes or tools used for such audits.
- Developers or IT staff might search for plugin configurations while troubleshooting or developing new features. Consider excluding processes initiated by trusted development environments or specific user groups involved in these activities.
- Monitoring tools that perform regular checks on system configurations could trigger this rule. Identify these tools and add them to an exclusion list to prevent false alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent potential lateral movement by the attacker.
- Terminate any suspicious processes related to the `grep` command that are actively searching for YUM/DNF plugin configurations.
- Conduct a thorough review of the YUM and DNF plugin configuration files and directories for unauthorized changes or additions, specifically in the paths `/etc/yum.conf`, `/usr/lib/yum-plugins/*`, `/etc/yum/pluginconf.d/*`, `/usr/lib/python*/site-packages/dnf-plugins/*`, `/etc/dnf/plugins/*`, and `/etc/dnf/dnf.conf`.
- Restore any altered plugin configurations from a known good backup to ensure system integrity.
- Implement file integrity monitoring on the YUM and DNF configuration directories to detect future unauthorized changes.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems have been compromised.
- Review and update access controls and permissions for users and processes interacting with YUM and DNF configurations to minimize the risk of unauthorized access.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
process.name == "grep" and process.args : "plugins*" and process.args like (
  "/etc/yum.conf", "/usr/lib/yum-plugins/*", "/etc/yum/pluginconf.d/*",
  "/usr/lib/python*/site-packages/dnf-plugins/*", "/etc/dnf/plugins/*", "/etc/dnf/dnf.conf"
) and
not ?process.parent.executable == "/usr/lib/venv-salt-minion/bin/python.original"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)