﻿---
title: Suspicious Network Tool Launched Inside A Container
description: This rule detects commonly abused network utilities running inside a container. Network utilities like nc, nmap, dig, tcpdump, ngrep, telnet, mitmproxy,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_suspicious_network_tool_launched_inside_container
products:
  - Elastic Security
---

# Suspicious Network Tool Launched Inside A Container
This rule detects commonly abused network utilities running inside a container. Network utilities like nc, nmap, dig,
tcpdump, ngrep, telnet, mitmproxy, zmap can be used for malicious purposes such as network reconnaissance, monitoring,
or exploitation, and should be monitored closely within a container.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://sysdig.com/blog/cve-2021-25741-kubelet-falco/](https://sysdig.com/blog/cve-2021-25741-kubelet-falco/)](https://sysdig.com/blog/cve-2021-25741-kubelet-falco/)

**Tags**:
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Tactic: Command and Control
- Tactic: Reconnaissance
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.

For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Network Tool Launched Inside A Container

Containers are lightweight, portable units that encapsulate applications and their dependencies, often used to ensure consistent environments across development and production. Adversaries exploit network tools within containers for reconnaissance or lateral movement, leveraging utilities like `nc` or `nmap` to map networks or intercept traffic. The detection rule identifies these tools' execution by monitoring process starts and arguments, flagging potential misuse for further investigation.

### Possible investigation steps

- Examine the process arguments to understand the specific command or options used, which may provide insight into the intent of the tool's execution.
- Check the container's creation and modification timestamps to determine if the container was recently deployed or altered, which could indicate suspicious activity.
- Investigate the user or service account associated with the process start event to assess if it aligns with expected behavior or if it might be compromised.
- Analyze network logs and traffic patterns from the container to identify any unusual outbound connections or data exfiltration attempts.
- Correlate the alert with other security events or logs from the same container or host to identify potential lateral movement or further malicious activity.


### False positive analysis

- Development and testing environments often use network tools for legitimate purposes such as debugging or network configuration. To manage this, create exceptions for containers identified as part of these environments by tagging them appropriately and excluding them from the rule.
- Automated scripts or orchestration tools may trigger network utilities for routine checks or maintenance tasks. Identify these scripts and whitelist their associated container IDs or process names to prevent false alerts.
- Some monitoring solutions deploy containers with built-in network tools for performance analysis. Verify the legitimacy of these containers and exclude them from the rule by using specific labels or container IDs.
- Containers used for educational or training purposes might intentionally run network tools. Ensure these containers are marked and excluded from detection by setting up rules based on their unique identifiers or labels.


### Response and remediation

- Immediately isolate the affected container to prevent further network reconnaissance or lateral movement. This can be done by restricting its network access or stopping the container entirely.
- Conduct a thorough review of the container's logs and process history to identify any unauthorized access or data exfiltration attempts. Focus on the execution of the flagged network utilities.
- Remove any unauthorized or suspicious network tools from the container to prevent further misuse. Ensure that only necessary and approved utilities are present.
- Patch and update the container image to address any vulnerabilities that may have been exploited. Rebuild and redeploy the container using the updated image.
- Implement network segmentation to limit the container's access to sensitive resources and reduce the potential impact of similar threats in the future.
- Enhance monitoring and alerting for the execution of network utilities within containers, ensuring that any future occurrences are detected promptly.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems or containers have been compromised.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
process.entry_leader.entry_meta.type == "container" and process.name in (
  "nc.traditional", "nc", "ncat", "netcat", "nmap", "tcpdump", "tshark", "ngrep", "telnet",
  "mitmproxy", "socat", "zmap", "masscan", "zgrab"
) and
not (process.name in ("nc.traditional", "nc", "ncat", "netcat") and process.args like ("-*z*", "localhost", "127.0.0.1"))
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Network Service Discovery
- Id: T1046
- Reference URL: [[https://attack.mitre.org/techniques/T1046/](https://attack.mitre.org/techniques/T1046/)](https://attack.mitre.org/techniques/T1046/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)
- Technique:
  - Name: Ingress Tool Transfer
- Id: T1105
- Reference URL: [[https://attack.mitre.org/techniques/T1105/](https://attack.mitre.org/techniques/T1105/)](https://attack.mitre.org/techniques/T1105/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Reconnaissance
- Id: TA0043
- Reference URL: [[https://attack.mitre.org/tactics/TA0043/](https://attack.mitre.org/tactics/TA0043/)](https://attack.mitre.org/tactics/TA0043/)
- Technique:
  - Name: Active Scanning
- Id: T1595
- Reference URL: [[https://attack.mitre.org/techniques/T1595/](https://attack.mitre.org/techniques/T1595/)](https://attack.mitre.org/techniques/T1595/)