﻿---
title: Potential Subnet Scanning Activity from Compromised Host
description: This rule detects potential subnet scanning activity from a compromised host. Subnet scanning is a common reconnaissance technique used by attackers to...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_subnet_scanning_activity_from_compromised_host
products:
  - Elastic Security
---

# Potential Subnet Scanning Activity from Compromised Host
This rule detects potential subnet scanning activity from a compromised host. Subnet scanning is a common reconnaissance
technique used by attackers to identify live hosts within a network range. A compromised host may exhibit subnet
scanning behavior when an attacker is attempting to map out the network topology, identify vulnerable hosts, or prepare
for further exploitation. This rule identifies potential subnet scanning activity by monitoring network connection
attempts from a single host to a large number of hosts within a short time frame. ESQL rules have limited fields
available in its alert documents. Make sure to review the original documents to aid in the investigation of this alert.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 1h
**Searches indices from**: `now-61m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 9
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Subnet Scanning Activity from Compromised Host

Subnet scanning is a reconnaissance method used by attackers to map network topology and identify active hosts. Adversaries exploit compromised hosts to perform these scans, seeking vulnerabilities for further attacks. The detection rule identifies such activity by monitoring Linux hosts for numerous connection attempts to different IPs within a short period, indicating potential scanning behavior. This helps in early detection and mitigation of network threats.

### Possible investigation steps

- Review the process executable identified in the alert to determine if it is a known or legitimate application that should be making network connections.
- Examine the destination IP addresses to identify any patterns or known malicious IPs, and check if these IPs are part of the organization's network or external.
- Investigate the specific host (using the agent.id) to assess if there are any signs of compromise, such as unusual processes or unauthorized access.
- Correlate the event timestamp with other logs or alerts to identify any concurrent suspicious activities or anomalies on the host.
- Check for any recent changes or updates on the host that might explain the scanning behavior, such as new software installations or configuration changes.


### False positive analysis

- High-volume legitimate network monitoring tools may trigger the rule. Identify and exclude these tools by adding their process executables to an exception list.
- Automated backup systems that connect to multiple hosts within a short timeframe can be mistaken for scanning activity. Review and exclude these systems by their process executable or agent ID.
- Security software performing routine network health checks might generate false positives. Verify these activities and create exceptions based on the specific process executable involved.
- Internal IT scripts or administrative tasks that involve connecting to numerous hosts for maintenance purposes can trigger alerts. Document these tasks and exclude them by process executable or agent ID.
- Cloud-based services or applications that require frequent connections to various hosts for functionality may appear as scanning. Identify these services and exclude them by their process executable or agent ID.


### Response and remediation

- Isolate the compromised host immediately from the network to prevent further scanning and potential lateral movement by the attacker.
- Terminate any suspicious processes identified by the executable name in the alert to stop ongoing scanning activities.
- Conduct a thorough examination of the compromised host to identify and remove any malware or unauthorized access tools that may have been installed.
- Reset credentials and review access permissions for the compromised host to ensure no unauthorized access persists.
- Update and patch the compromised host and any other vulnerable systems identified during the investigation to close security gaps.
- Monitor network traffic closely for any signs of continued scanning or other suspicious activities from other hosts, indicating potential further compromise.
- Escalate the incident to the security operations center (SOC) or incident response team for a comprehensive investigation and to determine if additional hosts are affected.


## Rule Query

```esql
from logs-endpoint.events.network-* metadata _id, _index, _version
| mv_expand event.action
| where
    host.os.type == "linux" and
    event.type == "start" and
    event.action == "connection_attempted" and
    not (
      process.executable in ("/usr/local/bin/prometheus", "/app/extra/chrome", "/usr/lib/virtualbox/VBoxHeadless", "/usr/bin/prometheus") or
      process.executable like "/usr/local/prometheus/*/prometheus" or
      process.executable like "/usr/share/elastic-agent/*" or
      process.executable like "/var/lib/docker/overlay*connectord" or
      process.executable like "/opt/rumble/bin/rumble-agent*" or
      process.executable like "/opt/gitlab/*" or
      process.executable like "/opt/google/chrome/chrome*" or
      process.executable like "/snap/firefox/*/firefox" or
      process.executable like "/var/lib/docker/overlay2/*/qbittorrent-nox"
    )
| keep
    @timestamp,
    _id,
    _index,
    _version,
    host.os.type,
    event.type,
    event.action,
    process.executable,
    destination.ip,
    agent.id,
    host.name,
    event.dataset,
    data_stream.namespace

| stats
    Esql.event_count = count(),
    Esql.destination_ip_count_distinct = count_distinct(destination.ip),
    Esql.agent_id_count_distinct = count_distinct(agent.id),
    Esql.host_name_values = values(host.name),
    Esql.agent_id_values = values(agent.id),
    Esql.event_dataset_values = values(event.dataset),
    Esql.data_stream_namespace_values = values(data_stream.namespace)
  by process.executable

| where
    Esql.agent_id_count_distinct == 1 and
    Esql.destination_ip_count_distinct > 250
| sort Esql.event_count asc

// Extract unique values to ECS fields for alerts exclusion
| eval agent.id = mv_min(Esql.agent_id_values),
       host.name = mv_min(Esql.host_name_values)

| keep agent.id, host.name, process.executable, Esql.*
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Network Service Discovery
- Id: T1046
- Reference URL: [[https://attack.mitre.org/techniques/T1046/](https://attack.mitre.org/techniques/T1046/)](https://attack.mitre.org/techniques/T1046/)