﻿---
title: Suspicious /proc/maps Discovery
description: Monitors for /proc//maps file reads. The /proc//maps file in Linux provides a memory map for a specific process, detailing the memory segments, permissions,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_proc_maps_read
products:
  - Elastic Security
---

# Suspicious /proc/maps Discovery
Monitors for /proc/*/maps file reads. The /proc/*/maps file in Linux provides a memory map for a specific process,
detailing the memory segments, permissions, and what files are mapped to these segments. Attackers may read a process's
memory map to identify memory addresses for code injection or process hijacking.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*
- logs-auditd_manager.auditd-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/arget13/DDexec](https://github.com/arget13/DDexec)](https://github.com/arget13/DDexec)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Tactic: Credential Access
- Data Source: Auditd Manager
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 8
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious /proc/maps Discovery

In Linux environments, the `/proc/*/maps` files provide detailed memory mapping of processes, crucial for system diagnostics. However, adversaries exploit this by reading these files to pinpoint memory addresses for malicious activities like code injection. The detection rule identifies suspicious reads of these files by monitoring specific command executions, such as `cat` or `grep`, initiated from common shell environments, flagging potential reconnaissance attempts.

### Possible investigation steps

- Review the process details, including the process name and arguments, to confirm if the access to /proc/*/maps was initiated by a legitimate user or application. Pay special attention to the process.name and process.args fields.
- Check the process.entry_leader.name to determine the shell environment from which the command was executed, and assess if this aligns with typical user behavior or known scripts.
- Investigate the user account associated with the process to determine if there are any signs of compromise or unusual activity, such as recent logins from unfamiliar IP addresses or changes in user permissions.
- Examine the parent process and any related child processes to understand the broader context of the command execution, looking for any signs of a script or automated task that might have triggered the alert.
- Correlate this event with other security alerts or logs from the same host or user to identify any patterns or sequences of suspicious activities that could indicate a larger attack or reconnaissance effort.


### False positive analysis

- System diagnostics tools may read /proc/*/maps files as part of routine checks. Identify these tools and create exceptions for their processes to avoid unnecessary alerts.
- Developers and system administrators might manually inspect /proc/*/maps during debugging or performance tuning. Establish a list of known users and processes that perform these actions regularly and exclude them from triggering the rule.
- Automated scripts for monitoring or logging purposes could access /proc/*/maps files. Review these scripts and whitelist them if they are verified to be non-malicious.
- Security software might access these files as part of its scanning operations. Confirm the legitimacy of such software and add it to an exception list to prevent false positives.
- Consider the context of the process entry leader. If certain shell environments are used predominantly for legitimate administrative tasks, adjust the rule to reduce sensitivity for those specific environments.


### Response and remediation

- Immediately isolate the affected system from the network to prevent potential lateral movement by the adversary.
- Terminate any suspicious processes identified as reading the `/proc/*/maps` files using commands like `cat` or `grep` from unauthorized shell environments.
- Conduct a memory analysis on the affected system to identify any injected code or unauthorized modifications in the process memory.
- Review and audit user accounts and permissions on the affected system to ensure that only authorized users have access to sensitive files and directories.
- Implement stricter access controls and monitoring on `/proc/*/maps` files to limit exposure and detect unauthorized access attempts.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are compromised.
- Update and enhance endpoint detection and response (EDR) solutions to improve monitoring and alerting for similar suspicious activities in the future.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
process.name in ("cat", "grep", "tail", "less", "more", "egrep", "fgrep", "awk") and process.args like "/proc/*/maps" and
not (
  ?process.parent.args in ("/usr/bin/finalrd", "/sbin/chkrootkit", "./uac", "/usr/sbin/chkrootkit") or
  ?process.parent.executable in ("/usr/sbin/chkrootkit", "/sbin/chkrootkit") or
  ?process.parent.name == "uac" or
  ?process.parent.executable in ("/opt/secl/linux-ir-scripts-v3/thieves.sh", "/opt/traps/rpm-installer/setup.sh") or
  ?process.working_directory like ("/opt/traps/deb-installer", "/opt/Tanium/TaniumClient/*") or
  ?process.parent.executable like ("/home/*/sunlight/thieves.sh")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Process Discovery
- Id: T1057
- Reference URL: [[https://attack.mitre.org/techniques/T1057/](https://attack.mitre.org/techniques/T1057/)](https://attack.mitre.org/techniques/T1057/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: Proc Filesystem
- Id: T1003.007
- Reference URL: [[https://attack.mitre.org/techniques/T1003/007/](https://attack.mitre.org/techniques/T1003/007/)](https://attack.mitre.org/techniques/T1003/007/)