﻿---
title: Hping Process Activity
description: Hping ran on a Linux host. Hping is a FOSS command-line packet analyzer and has the ability to construct network packets for a wide variety of network...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_linux_hping_activity
products:
  - Elastic Security
---

# Hping Process Activity
Hping ran on a Linux host. Hping is a FOSS command-line packet analyzer and has the ability to construct network packets
for a wide variety of network security testing applications, including scanning and firewall auditing.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-auditd_manager.auditd-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://en.wikipedia.org/wiki/Hping](https://en.wikipedia.org/wiki/Hping)](https://en.wikipedia.org/wiki/Hping)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: Auditd Manager
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 212
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from one of the following integrations:
- Elastic Defend
- Auditbeat


### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


### Auditbeat Setup

Auditbeat is a lightweight shipper that you can install on your servers to audit the activities of users and processes on your systems. For example, you can use Auditbeat to collect and centralize audit events from the Linux Audit Framework. You can also use Auditbeat to detect changes to critical files, like binaries and configuration files, and identify potential security policy violations.

#### The following steps should be executed in order to add the Auditbeat on a Linux System:

- Elastic provides repositories available for APT and YUM-based distributions. Note that we provide binary packages, but no source packages.
- To install the APT and YUM repositories follow the setup instructions in this [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setup-repositories.html).
- To run Auditbeat on Docker follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-docker.html).
- To run Auditbeat on Kubernetes follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-kubernetes.html).
- For complete “Setup and Run Auditbeat” information refer to the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setting-up-and-running.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Hping Process Activity

Hping is a versatile command-line tool used for crafting and analyzing network packets, often employed in network security testing. Adversaries may exploit Hping to perform reconnaissance, such as scanning networks or probing firewalls, to gather system information. The detection rule identifies Hping's execution on Linux systems by monitoring specific process start events, helping to flag potential misuse indicative of discovery tactics.

### Possible investigation steps

- Review the process start event details to confirm the execution of Hping, focusing on the process.name field to ensure it matches "hping", "hping2", or "hping3".
- Identify the user account associated with the Hping process by examining the user context in the event data to determine if the activity aligns with expected behavior for that user.
- Analyze the command line arguments used with the Hping process to understand the intent of the execution, such as specific network targets or options that indicate scanning or probing activities.
- Check the timing and frequency of the Hping process execution to assess whether it aligns with routine network testing schedules or if it appears anomalous.
- Investigate the source and destination IP addresses involved in the Hping activity to identify potential targets and assess whether they are internal or external to the organization.
- Correlate the Hping activity with other security events or alerts from the same host or network segment to identify any related suspicious activities or patterns.
- Consult with the system owner or network security team to verify if the Hping activity was authorized as part of legitimate security testing or if it requires further investigation.


### False positive analysis

- Routine network testing by IT teams may trigger the rule when using Hping for legitimate purposes. To manage this, create exceptions for known IP addresses or user accounts involved in regular network audits.
- Automated scripts or cron jobs that utilize Hping for monitoring network performance can lead to false positives. Identify these scripts and exclude their execution paths or associated user accounts from the detection rule.
- Security training exercises or penetration testing activities might involve Hping usage. Coordinate with security teams to whitelist these activities by specifying time windows or specific user roles.
- Development or testing environments where Hping is used for application testing can cause alerts. Exclude these environments by filtering based on hostnames or network segments associated with non-production systems.


### Response and remediation

- Immediately isolate the affected Linux host from the network to prevent further reconnaissance or potential lateral movement by the adversary.
- Terminate any active Hping processes on the affected host to stop ongoing packet crafting or network probing activities.
- Conduct a thorough review of network logs and firewall configurations to identify any unauthorized access or anomalies that may have been exploited using Hping.
- Perform a comprehensive scan of the affected system for additional indicators of compromise, such as unauthorized user accounts or unexpected changes to system files.
- Reset credentials and review access permissions for accounts on the affected host to ensure no unauthorized access persists.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Update detection and monitoring systems to enhance visibility and alerting for similar reconnaissance activities, ensuring rapid response to future threats.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
 event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
 process.name in ("hping", "hping2", "hping3")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)