﻿---
title: Kubeconfig File Discovery
description: The kubeconfig file is a critical component in Kubernetes environments, containing configuration details for accessing and managing Kubernetes clusters...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/discovery_kubeconfig_file_discovery
products:
  - Elastic Security
---

# Kubeconfig File Discovery
The kubeconfig file is a critical component in Kubernetes environments, containing configuration
details for accessing and managing Kubernetes clusters. Attackers may attempt to get access to,
create, or modify kubeconfig files to gain unauthorized initial access to Kubernetes clusters or
move laterally within the cluster. This rule detects process discovery executions that involve
kubeconfig files, particularly those executed from common shell environments or world-writeable
directories.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*
- logs-cloud_defend.process*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://kubernetes-threat-matrix.redguard.ch/initial-access/kubeconfig-file/](https://kubernetes-threat-matrix.redguard.ch/initial-access/kubeconfig-file/)](https://kubernetes-threat-matrix.redguard.ch/initial-access/kubeconfig-file/)
- [[https://kubenomicon.com/Initial_access/Kubeconfig_file.html](https://kubenomicon.com/Initial_access/Kubeconfig_file.html)](https://kubenomicon.com/Initial_access/Kubeconfig_file.html)

**Tags**:
- Domain: Endpoint
- Domain: Container
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Discovery
- Data Source: Elastic Defend
- Data Source: Elastic Defend for Containers
- Resources: Investigation Guide

**Version**: 103
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubeconfig File Discovery

Kubeconfig files are essential in Kubernetes, storing credentials and configurations for cluster access. Adversaries may target these files to gain unauthorized access or move laterally within clusters. The detection rule identifies suspicious processes interacting with kubeconfig files, especially from common shell environments or risky directories, flagging potential misuse by excluding benign commands like 'stat' or 'md5sum'.

### Possible investigation steps

- Review the process details to identify the parent process name and executable path, focusing on those originating from common shell environments or risky directories like /tmp, /var/tmp, or /dev/shm.
- Examine the process arguments to determine if they include references to sensitive kubeconfig files such as admin.conf, kubelet.conf, or any files within /etc/kubernetes or ~/.kube directories.
- Check the working directory of the process to see if it aligns with known Kubernetes configuration paths like /etc/kubernetes or ~/.kube, which may indicate an attempt to access or modify kubeconfig files.
- Investigate the user account associated with the process to assess whether it has legitimate access to Kubernetes configurations or if it might be compromised.
- Correlate the event with other recent activities from the same user or IP address to identify any patterns of suspicious behavior or potential lateral movement within the cluster.
- Review any related alerts or logs for the same host or container to gather additional context on the system's state and any other potential indicators of compromise.


### False positive analysis

- Processes like 'stat' and 'md5sum' are excluded from detection as they are commonly used for legitimate file checks. Ensure these exclusions are correctly configured to prevent unnecessary alerts.
- Scripts located in user directories such as '/home/*/.kube' may trigger alerts if they interact with kubeconfig files. Consider adding exceptions for known scripts or users that regularly access these files for legitimate purposes.
- Processes originating from world-writeable directories like '/tmp' or '/var/tmp' can be flagged. Review these alerts to identify routine operations and whitelist specific processes or directories that are part of regular maintenance tasks.
- Alerts triggered by processes with names matching patterns like '*.sh' may include legitimate scripts. Evaluate these scripts and exclude them if they are part of standard operations or administrative tasks.
- Regular administrative tasks involving kubeconfig files in directories like '/etc/kubernetes' may be flagged. Implement exceptions for known administrative processes to reduce false positives while maintaining security oversight.


### Response and remediation

- Immediately isolate the affected system to prevent further unauthorized access to the Kubernetes cluster.
- Revoke any compromised credentials associated with the kubeconfig files and issue new credentials to authorized users.
- Conduct a thorough review of recent access logs and audit trails for the Kubernetes cluster to identify any unauthorized access or lateral movement attempts.
- Restore any modified or deleted kubeconfig files from a secure backup to ensure the integrity of the cluster configuration.
- Implement stricter access controls and permissions for directories containing kubeconfig files, ensuring only authorized personnel have access.
- Escalate the incident to the security operations team for further investigation and to determine if additional clusters or systems are affected.
- Enhance monitoring and alerting for suspicious activities related to kubeconfig files, leveraging the MITRE ATT&CK framework to identify potential discovery tactics.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  process.parent.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish") or
  (
    process.parent.executable like ("/tmp/*", "/var/tmp/*", "/dev/shm/*", "/root/*", "/home/*") or
    process.parent.name like (".*", "*.sh")
  )
) and
(
  (
    process.working_directory like ("/etc/kubernetes", "/root/.kube", "/home/*/.kube") and
    process.args in ("kubeconfig", "admin.conf", "super-admin.conf", "kubelet.conf", "controller-manager.conf", "scheduler.conf")
  ) or
  process.args like (
    "/etc/kubernetes/admin.conf",
    "/etc/kubernetes/super-admin.conf",
    "/etc/kubernetes/kubelet.conf",
    "/etc/kubernetes/controller-manager.conf",
    "/etc/kubernetes/scheduler.conf",
    "/home/*/.kube/config",
    "/root/.kube/config",
    "/var/lib/*/kubeconfig"
  )
) and not (
  process.name in ("stat", "md5sum", "dirname") or
  (process.name like "python*" and process.args == "/usr/bin/yq" and process.parent.name == "fish") or
  process.executable in (
    "/usr/bin/file", "/usr/bin/readlink", "/bin/readlink", "/bin/file", "/tmp/newroot/bin/readlink",
    "/tmp/newroot/bin/file", "/usr/local/bin/helm"
  )
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)