﻿---
title: File Creation in /var/log via Suspicious Process
description: This rule detects the creation of files in the /var/log/ directory via process executables located in world-writeable locations or via hidden processes...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_var_log_file_creation_by_unsual_process
products:
  - Elastic Security
---

# File Creation in /var/log via Suspicious Process
This rule detects the creation of files in the /var/log/ directory via process executables located in world-writeable
locations or via hidden processes. Attackers may attempt to hide their activities by creating files in the /var/log/
directory, which is commonly used for logging system events.
**Rule type**: new_terms
**Rule indices**:
- logs-endpoint.events.file*
- logs-sentinel_one_cloud_funnel.*
- endgame-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Execution
- Tactic: Persistence
- Data Source: Elastic Defend
- Data Source: SentinelOne
- Data Source: Elastic Endgame
- Resources: Investigation Guide

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating File Creation in /var/log via Suspicious Process

In Linux environments, the `/var/log` directory is crucial for storing system logs, which are essential for monitoring and troubleshooting. Adversaries may exploit this by creating files in this directory using executables from insecure locations, aiming to conceal their activities. The detection rule identifies such suspicious file creations by monitoring processes from world-writable or hidden paths, flagging potential evasion tactics.

### Possible investigation steps

- Review the process executable path to determine if it originates from a world-writable or hidden location such as /tmp, /var/tmp, /dev/shm, or similar directories. This can indicate potential malicious activity.
- Examine the process name and its parent process to understand the context of the file creation and identify if it is associated with known legitimate or suspicious activities.
- Check the file path in /var/log to see if the created file has any unusual naming conventions or lacks a file extension, which might suggest an attempt to hide or disguise the file.
- Investigate the user account under which the process was executed to determine if it has the necessary permissions and if the activity aligns with the user's typical behavior.
- Correlate the event with other logs or alerts from the same host to identify any related suspicious activities or patterns that could indicate a broader compromise.
- Assess the risk and impact of the file creation by considering the severity and risk score provided, and prioritize further actions based on this assessment.


### False positive analysis

- System maintenance scripts or legitimate applications may create temporary log files in /var/log using executables from directories like /tmp or /var/tmp. To handle this, identify and whitelist these known processes by their executable paths.
- Automated backup or monitoring tools might generate files in /var/log as part of their routine operations. Review these tools and exclude their processes from the rule to prevent unnecessary alerts.
- Development or testing environments often involve scripts that create log files in /var/log for debugging purposes. Consider excluding these environments from the rule or creating specific exceptions for known development processes.
- Some system updates or package installations might temporarily use world-writable directories for executable scripts that interact with /var/log. Monitor these activities and create exceptions for trusted update processes to reduce false positives.


### Response and remediation

- Isolate the affected system from the network to prevent further malicious activity and lateral movement.
- Terminate any suspicious processes identified as originating from world-writable or hidden paths, especially those involved in file creation within /var/log.
- Conduct a thorough review of the files created in /var/log to determine if they contain malicious content or scripts, and remove any unauthorized files.
- Restore any affected system files or logs from a known good backup to ensure system integrity and continuity of logging.
- Implement stricter permissions on directories like /tmp, /var/tmp, and /dev/shm to prevent unauthorized execution of processes from these locations.
- Escalate the incident to the security operations team for further analysis and to determine if additional systems are compromised.
- Update and enhance monitoring rules to detect similar suspicious activities in the future, focusing on process execution from insecure locations and unauthorized file creation in critical directories.


## Rule Query

```kuery
event.category:file and host.os.type:linux and event.action:(creation or file_create_event or file_rename_event or rename) and
(process.executable:(/tmp/* or /var/tmp/* or /dev/shm/* or ./* or /boot/*) or process.name:.*) and
file.path:/var/log/* and not file.extension:* and
not process.executable:("./usr/bin/podman" or "./install" or /tmp/vmis.*/install/vmware-installer/vmis-launcher or /tmp/ubuntu-release-upgrader-*)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Hide Artifacts
- Id: T1564
- Reference URL: [[https://attack.mitre.org/techniques/T1564/](https://attack.mitre.org/techniques/T1564/)](https://attack.mitre.org/techniques/T1564/)
- Sub Technique:
  - Name: Hidden Files and Directories
- Id: T1564.001
- Reference URL: [[https://attack.mitre.org/techniques/T1564/001/](https://attack.mitre.org/techniques/T1564/001/)](https://attack.mitre.org/techniques/T1564/001/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)