﻿---
title: Suspicious Kernel Feature Activity
description: This rule detects the modification and reading of kernel features through built-in commands. Attackers may collect information, disable or weaken Linux...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_sysctl_kernel_feature_activity
products:
  - Elastic Security
---

# Suspicious Kernel Feature Activity
This rule detects the modification and reading of kernel features through built-in commands. Attackers may collect
information, disable or weaken Linux kernel protections. For example, an attacker may modify ASLR protection by
disabling kernel.randomize_va_space, allow ptrace by setting kernel.yama.ptrace_scope to 0, or disable the
NMI watchdog by setting kernel.nmi_watchdog to 0. These changes may be used to impair defenses and evade detection.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*
- logs-crowdstrike.fdr*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Discovery
- Data Source: Elastic Defend
- Resources: Investigation Guide
- Data Source: Crowdstrike

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Kernel Feature Activity

Kernel features in Linux systems are critical for maintaining security and stability. They control various system behaviors, such as memory randomization and process tracing. Adversaries may exploit these features to weaken defenses, for instance, by disabling address space layout randomization (ASLR) or enabling unrestricted process tracing. The detection rule identifies suspicious activities by monitoring command executions that modify or read kernel settings, focusing on unusual patterns or contexts that suggest malicious intent.

### Possible investigation steps

- Review the process command line to identify which specific kernel feature was accessed or modified, focusing on entries like kernel.randomize_va_space or kernel.yama.ptrace_scope.
- Examine the parent process executable and name to determine the context in which the suspicious command was executed, checking for unusual or unauthorized parent processes.
- Investigate the user account associated with the process execution to assess whether the activity aligns with expected behavior for that user.
- Check for any recent changes in the /etc/sysctl.conf or /etc/sysctl.d/ directories that might indicate unauthorized modifications to kernel settings.
- Analyze the system's process execution history to identify any patterns or sequences of commands that suggest a broader attack or compromise.
- Correlate the alert with other security events or logs to determine if this activity is part of a larger attack campaign or isolated incident.


### False positive analysis

- System administrators or automated scripts may frequently modify kernel settings for legitimate purposes such as performance tuning or system maintenance. To handle these, identify and whitelist known administrative scripts or processes that regularly perform these actions.
- Security tools or monitoring solutions might execute commands that read kernel settings as part of their normal operation. Review and exclude these tools from triggering alerts by adding them to an exception list based on their process names or command patterns.
- Developers and testers might disable certain kernel features temporarily during debugging or testing phases. Coordinate with development teams to document these activities and exclude them from detection by specifying the relevant process names or command lines.
- Some system management tools may use commands like sysctl to apply configuration changes across multiple systems. If these tools are verified as non-threatening, exclude their specific command patterns or parent processes from triggering the rule.
- Regular system updates or configuration management processes might involve reading or modifying kernel settings. Identify these processes and add them to an exception list to prevent unnecessary alerts.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further exploitation or lateral movement by the adversary.
- Review and revert any unauthorized changes to kernel settings, such as ASLR, ptrace scope, or NMI watchdog, to their secure defaults using sysctl or by editing configuration files.
- Conduct a thorough examination of the system for signs of compromise, including checking for unauthorized access, unusual processes, or modifications to critical files.
- Restore the system from a known good backup if the integrity of the system is compromised and cannot be reliably remediated.
- Implement additional monitoring and logging for kernel feature modifications to detect similar activities in the future, ensuring alerts are configured for immediate response.
- Escalate the incident to the security operations center (SOC) or relevant security team for further investigation and correlation with other potential threats across the network.
- Review and update security policies and configurations to prevent unauthorized kernel modifications, including enforcing stricter access controls and auditing procedures.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action in ("exec", "ProcessRollup2") and
process.command_line : (
  "*/etc/sysctl.conf*", "*/etc/sysctl.d/*", "*/proc/sys/kernel/nmi_watchdog*",
  "*/proc/sys/vm/nr_hugepages*", "*/proc/sys/kernel/yama/ptrace_scope*",
  "*/proc/sys/kernel/randomize_va_space*", "*/proc/sys/vm/drop_caches*",
  "*/proc/sys/kernel/sysrq*", "*grsecurity*", "*exec-shield*",
  "*kernel.randomize_va_space*", "*kernel.yama.ptrace_scope*",
  "*kernel.nmi_watchdog*", "*vm.nr_hugepages*", "*vm.drop_caches*",
  "*kernel.sysrq*"
) and
?process.parent.executable != null and 
(
  (process.name == "tee" and process.args like "-*a*") or
  (process.name == "cat" and not process.parent.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish")) or
  (process.name == "grep" and process.args_count == 3 and not process.parent.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish")) or
  (process.name == "sysctl" and process.args like ("*-w*", "*--write*", "*=*")) or
  (process.name in ("bash", "dash", "sh", "tcsh", "csh", "zsh", "ksh", "fish") and process.args == "-c" and process.args : "*echo *")
) and
not (
  process.parent.executable in (
    "/opt/novell/groupwise/agents/bin/gwia", "/opt/novell/groupwise/agents/bin/gwmta", "/opt/novell/groupwise/agents/bin/gwpoa",
    "/opt/illumio_ven/system/etc/init.d/illumio-firewall", "/usr/bin/oracle-database-preinstall-19c-verify", "/usr/bin/make",
    "/usr/local/qualys/cloud-agent/bin/qualys-scan-util"
  ) or
  process.parent.executable like "/tmp/CVU_19_resource*/checkmemlock.sh" or
  process.parent.args == "/usr/share/mysql/mysql-systemd-start" or
  process.parent.command_line like "*ansible*" or
  (process.parent.name in ("crond", "cron") and process.command_line like "*drop_caches*")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Indicator Blocking
- Id: T1562.006
- Reference URL: [[https://attack.mitre.org/techniques/T1562/006/](https://attack.mitre.org/techniques/T1562/006/)](https://attack.mitre.org/techniques/T1562/006/)
- Technique:
  - Name: Subvert Trust Controls
- Id: T1553
- Reference URL: [[https://attack.mitre.org/techniques/T1553/](https://attack.mitre.org/techniques/T1553/)](https://attack.mitre.org/techniques/T1553/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: System Information Discovery
- Id: T1082
- Reference URL: [[https://attack.mitre.org/techniques/T1082/](https://attack.mitre.org/techniques/T1082/)](https://attack.mitre.org/techniques/T1082/)