﻿---
title: Suspicious Path Mounted
description: This rule detects suspicious paths mounted on Linux systems. The mount command is used to attach filesystems to the system, and attackers may use it to...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_suspicious_path_mounted
products:
  - Elastic Security
---

# Suspicious Path Mounted
This rule detects suspicious paths mounted on Linux systems. The mount command is used to attach filesystems to
the system, and attackers may use it to mount malicious filesystems or directories for data exfiltration or
persistence.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Suspicious Path Mounted

In Linux environments, the mount command integrates filesystems, enabling access to storage devices. Adversaries exploit this by mounting malicious filesystems in sensitive directories like /tmp or /dev/shm to exfiltrate data or maintain persistence. The detection rule identifies such activities by monitoring the execution of the mount command in unusual paths, excluding legitimate parent processes, thus highlighting potential threats.

### Possible investigation steps

- Review the process details to confirm the execution of the mount command, focusing on the process.name and process.args fields to identify the specific path being mounted.
- Examine the process.parent.executable field to determine the parent process that initiated the mount command, ensuring it is not a known legitimate process.
- Investigate the user account associated with the process to determine if it is a privileged account or if there are any signs of compromise.
- Check for any recent changes or anomalies in the mounted directories, such as unexpected files or modifications, to assess potential data exfiltration or persistence activities.
- Correlate the event with other security alerts or logs from the same host to identify any related suspicious activities or patterns that could indicate a broader attack.


### False positive analysis

- System maintenance scripts may trigger the rule if they mount filesystems in monitored paths. Review and whitelist these scripts by adding their parent executable paths to the exclusion list.
- Backup processes that temporarily mount directories for data transfer can be mistaken for suspicious activity. Identify these processes and exclude their parent executables to prevent false alerts.
- Software installations or updates that require mounting filesystems in user directories might be flagged. Verify these activities and add the responsible parent executables to the exclusion criteria.
- Development tools that use temporary mounts for testing purposes can generate false positives. Recognize these tools and exclude their parent executables to reduce noise.
- Custom administrative scripts that perform legitimate mounting operations should be reviewed and, if deemed safe, their parent executables should be added to the exclusion list.


### Response and remediation

- Immediately isolate the affected system to prevent further data exfiltration or persistence by disconnecting it from the network.
- Terminate any suspicious mount processes identified in the alert to halt potential malicious activity.
- Conduct a thorough review of mounted filesystems and directories to identify and unmount any unauthorized or suspicious mounts.
- Restore any compromised files or directories from backups, ensuring they are clean and free from malicious modifications.
- Implement stricter access controls and permissions on sensitive directories like /tmp, /var/tmp, /dev/shm, /home, and /root to prevent unauthorized mounting.
- Escalate the incident to the security operations team for further investigation and to assess the scope of the threat, including potential lateral movement or additional compromised systems.
- Enhance monitoring and detection capabilities by configuring alerts for unusual mount activities and integrating threat intelligence feeds to identify similar tactics used by adversaries.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and process.name == "mount" and 
process.args like ("/tmp/*", "/var/tmp/*", "/dev/shm/*", "/home/*", "/root/*", "/mount") and process.parent.executable != null and
not (
  process.parent.executable like (
    "/bin/*", "/usr/bin/*", "/usr/local/bin/*", "/sbin/*", "/usr/sbin/*", "/usr/local/sbin/*", "/usr/libexec/*",
    "/usr/local/nutanix/ngt/*/python"
  ) or
  process.parent.executable in (
    "/usr/lib/uptrack/ksplice-apply", "/usr/lib/Acronis/BackupAndRecovery/mms",
    "/usr/lib/Acronis/BackupAndRecovery/service_process-bin", "/usr/lib/systemd/systemd", "/etc/grub.d/10_linux_zfs",
    "./tools/image-summary", "/nfsplugin", "/usr/share/ksplice/ksplice-apply", "/lib/systemd/systemd"
  ) or
  process.parent.name == "snapd"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Hide Artifacts
- Id: T1564
- Reference URL: [[https://attack.mitre.org/techniques/T1564/](https://attack.mitre.org/techniques/T1564/)](https://attack.mitre.org/techniques/T1564/)