﻿---
title: Potential Process Name Stomping with Prctl
description: This rule leverages Auditd data to detect the use of the "prctl" syscall to potentially hide a process by changing its name. The "prctl" syscall is used...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_prctl_process_name_tampering
products:
  - Elastic Security
---

# Potential Process Name Stomping with Prctl
This rule leverages Auditd data to detect the use of the "prctl" syscall to potentially hide a process
by changing its name. The "prctl" syscall is used to control various process attributes. Attackers can use
this syscall to change the name of a process to a hidden directory or file, making it harder to detect. The
query looks for the "prctl" syscall with the "PR_SET_NAME" argument set to "f" (PR_SET_NAME is used to set
the name of a process).
**Rule type**: eql
**Rule indices**:
- logs-auditd_manager.auditd-*
- auditbeat-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://haxrob.net/process-name-stomping/](https://haxrob.net/process-name-stomping/)](https://haxrob.net/process-name-stomping/)
- [[https://haxrob.net/hiding-in-plain-sight-part-2/](https://haxrob.net/hiding-in-plain-sight-part-2/)](https://haxrob.net/hiding-in-plain-sight-part-2/)
- [[https://www.elastic.co/security-labs/linux-detection-engineering-with-auditd](https://www.elastic.co/security-labs/linux-detection-engineering-with-auditd)](https://www.elastic.co/security-labs/linux-detection-engineering-with-auditd)

**Tags**:
- Data Source: Auditd Manager
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 6
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Auditd Manager.

### Auditd Manager Integration Setup

The Auditd Manager Integration receives audit events from the Linux Audit Framework which is a part of the Linux kernel.
Auditd Manager provides a user-friendly interface and automation capabilities for configuring and monitoring system auditing through the auditd daemon. With `auditd_manager`, administrators can easily define audit rules, track system events, and generate comprehensive audit reports, improving overall security and compliance in the system.

#### The following steps should be executed in order to add the Elastic Agent System integration "auditd_manager" on a Linux System:

- Go to the Kibana home page and click “Add integrations”.
- In the query bar, search for “Auditd Manager” and select the integration to see more details about it.
- Click “Add Auditd Manager”.
- Configure the integration name and optionally add a description.
- Review optional and advanced settings accordingly.
- Add the newly installed “auditd manager” to an existing or a new agent policy, and deploy the agent on a Linux system from which auditd log files are desirable.
- Click “Save and Continue”.
- For more details on the integration refer to the [helper guide](https://docs.elastic.co/integrations/auditd_manager).


#### Rule Specific Setup Note

Auditd Manager subscribes to the kernel and receives events as they occur without any additional configuration.
However, if more advanced configuration is required to detect specific behavior, audit rules can be added to the integration in either the "audit rules" configuration box or the "auditd rule files" box by specifying a file to read the audit rules from.
- For this detection rule the following additional audit rules are required to be added to the integration:
  -- "-a exit,always -F arch=b64 -S prctl -k prctl_detection"


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Process Name Stomping with Prctl

The `prctl` syscall in Linux allows processes to modify their attributes, including renaming themselves. This capability can be exploited by attackers to disguise malicious processes, making them harder to identify. The detection rule monitors for `prctl` invocations with specific arguments indicative of name changes, especially when linked to suspicious directories, thus flagging potential evasion attempts.

### Possible investigation steps

- Review the process details associated with the alert, focusing on the executable path to determine if it matches any suspicious directories listed in the query, such as "/tmp/*" or "/var/tmp/*".
- Examine the process tree to identify the parent process and any child processes spawned by the suspicious process, which may provide context on how the process was initiated and its potential impact.
- Check the command line arguments and environment variables of the process to gather additional context on its intended function and any anomalies.
- Investigate the user account under which the process is running to determine if it aligns with expected behavior or if it indicates potential compromise.
- Correlate the alert with other security events or logs, such as file modifications or network connections, to identify any related malicious activity or patterns.
- Assess the historical activity of the process executable and its associated files to determine if this behavior is new or part of a recurring pattern.


### False positive analysis

- System maintenance scripts may invoke prctl to rename processes for legitimate reasons. Review scheduled tasks and maintenance scripts in directories like /etc/cron.* and /etc/init.d to identify benign uses.
- Development environments often use prctl for testing purposes. Exclude known development directories such as /home/developer or /tmp/dev from the rule to reduce noise.
- Some monitoring or logging tools might use prctl to rename their processes for clarity. Identify these tools and add their executable paths to an exception list.
- Custom scripts or applications that manage process names for operational reasons should be documented. Exclude these scripts by specifying their paths in the rule configuration.
- Regularly review and update the exception list to ensure it reflects the current environment and does not inadvertently exclude new threats.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further malicious activity or lateral movement.
- Terminate any suspicious processes identified by the detection rule, especially those with altered names in critical directories.
- Conduct a thorough review of the affected system's process tree and file system to identify any additional signs of compromise or persistence mechanisms.
- Restore any altered or suspicious files from a known good backup to ensure system integrity.
- Update and patch the affected system to close any vulnerabilities that may have been exploited by the attacker.
- Monitor the network for any signs of similar activity or attempts to use the `prctl` syscall with the `PR_SET_NAME` argument in other systems.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if broader organizational impacts exist.


## Rule Query

```eql
process where host.os.type == "linux" and auditd.data.syscall == "prctl" and auditd.data.a0 == "f" and
process.executable like (
  "/boot/*", "/dev/shm/*", "/etc/cron.*/*", "/etc/init.d/*", "/var/run/*", "/etc/update-motd.d/*",
  "/tmp/*", "/var/log/*", "/var/tmp/*", "/home/*", "/run/shm/*", "/run/*", "./*"
) and
not process.executable like ("/home/*/.vscode-server/*", "/tmp/VeeamAgent*", "/home/*/.xmonad/xmonad*linux*")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Match Legitimate Resource Name or Location
- Id: T1036.005
- Reference URL: [[https://attack.mitre.org/techniques/T1036/005/](https://attack.mitre.org/techniques/T1036/005/)](https://attack.mitre.org/techniques/T1036/005/)