﻿---
title: Potential Kubectl Masquerading via Unexpected Process
description: This rule detects potential kubectl masquerading activity by monitoring for process events where the process name is not "kubectl" but the command line...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_potential_kubectl_masquerading
products:
  - Elastic Security
---

# Potential Kubectl Masquerading via Unexpected Process
This rule detects potential kubectl masquerading activity by monitoring for process events where the process name
is not "kubectl" but the command line arguments include kubectl-related commands. This could indicate an adversary
attempting to masquerade as legitimate kubectl activity to evade detection. This rule covers evasion gaps
introduced by renaming the kubectl binary, or placing it in an unusual directory.
**Rule type**: eql
**Rule indices**:
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*
- logs-cloud_defend.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://kubernetes.io/docs/reference/kubectl/](https://kubernetes.io/docs/reference/kubectl/)](https://kubernetes.io/docs/reference/kubectl/)

**Tags**:
- Domain: Endpoint
- Domain: Container
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Data Source: Elastic Defend for Containers
- Resources: Investigation Guide

**Version**: 102
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Kubectl Masquerading via Unexpected Process

Kubectl is a command-line tool for interacting with Kubernetes clusters, crucial for managing containerized applications. Adversaries may exploit this by renaming the kubectl binary or placing it in unusual directories to mimic legitimate activity and evade detection. The detection rule identifies such masquerading by monitoring for non-standard process names executing kubectl-related commands, thus highlighting potential evasion attempts.

### Possible investigation steps

- Review the process executable path to determine if it is located in a non-standard directory such as /tmp, /var/tmp, /dev/shm, or other specified paths in the query.
- Examine the process name to check if it deviates from the expected "kubectl" name, which could indicate an attempt to masquerade the process.
- Analyze the command line arguments used in the process to identify any kubectl-related commands, such as "get", "describe", "exec", "port-forward", or authentication commands, which may suggest unauthorized access or activity.
- Investigate the user account associated with the process to determine if it has legitimate access to execute kubectl commands or if it might be compromised.
- Check for any recent changes or anomalies in the Kubernetes cluster that could correlate with the suspicious process activity, such as unauthorized deployments or configuration changes.
- Review system logs and other security alerts around the time of the event to identify any additional indicators of compromise or related suspicious activities.
- If possible, capture and analyze network traffic associated with the process to detect any unusual or unauthorized communication with the Kubernetes API server or other cluster components.


### False positive analysis

- Processes running in development or testing environments may trigger alerts if kubectl is executed from non-standard directories. To manage this, create exceptions for known development paths where kubectl is legitimately used.
- Automated scripts or CI/CD pipelines that use kubectl from custom directories might be flagged. Identify these scripts and exclude their specific paths or process names from the rule.
- Some legitimate applications might wrap kubectl commands for functionality, leading to unexpected process names. Review these applications and add their process names to the exclusion list if they are verified as non-threatening.
- Users with custom kubectl installations in home directories could cause false positives. Verify these installations and exclude the specific user paths if they are deemed safe.
- Temporary or experimental setups where kubectl is renamed for testing purposes might be mistakenly flagged. Document these setups and apply temporary exclusions during the testing phase.


### Response and remediation

- Immediately isolate the affected host to prevent further unauthorized access or lateral movement within the network.
- Terminate any suspicious processes identified by the detection rule that are masquerading as kubectl to halt potential malicious activity.
- Conduct a thorough review of the affected system's logs and command history to identify any unauthorized kubectl commands executed and assess the scope of the compromise.
- Revoke any potentially compromised credentials or access tokens associated with the Kubernetes cluster to prevent further unauthorized access.
- Restore any altered or deleted Kubernetes resources from backups, ensuring the integrity and availability of the cluster's services.
- Implement stricter access controls and monitoring on the Kubernetes cluster, such as enforcing the principle of least privilege and enabling audit logging for kubectl commands.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems or data have been affected.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
event.action in ("exec", "exec_event", "start", "executed", "process_started") and
(
  process.executable like~ ("/tmp/*", "/var/tmp/*", "/dev/shm/*", "/root/*", "/var/www/*", "./kubectl") or
  process.name like ".*"
) and
process.args like~ (

  // get and describe commands
  "*get po*", "*get deploy*", "*get node*", "*get svc*", "*get service*", "*get secret*", "*get clusterrole*", "*get ingress*",
  "*get configmap*", "*describe po*", "*describe deploy*", "*describe node*", "*describe svc*", "*describe service*",
  "*describe secret*", "*describe configmap*", "*describe clusterrole*", "*describe ingress*",
  
  // exec commands
  "*exec -it*", "*exec --stdin*", "*exec --tty*",
  
  // networking commands
  "*port-forward* ", "*proxy --port*", "*run --image=*", "*expose*",

  // authentication/impersonation commands
  "*auth can-i*", "*--kubeconfig*", "*--as *", "*--as=*", "*--as-group*", "*--as-uid*"
) and not (
  process.executable like "/tmp/newroot/*" or
  process.name == ".flatpak-wrapped"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Rename Legitimate Utilities
- Id: T1036.003
- Reference URL: [[https://attack.mitre.org/techniques/T1036/003/](https://attack.mitre.org/techniques/T1036/003/)](https://attack.mitre.org/techniques/T1036/003/)
- Technique:
  - Name: Hide Artifacts
- Id: T1564
- Reference URL: [[https://attack.mitre.org/techniques/T1564/](https://attack.mitre.org/techniques/T1564/)](https://attack.mitre.org/techniques/T1564/)