﻿---
title: Potential Hex Payload Execution via Command-Line
description: This rule detects when a process executes a command line containing hexadecimal characters. Malware authors may use hexadecimal encoding to obfuscate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_hex_payload_execution_via_commandline
products:
  - Elastic Security
---

# Potential Hex Payload Execution via Command-Line
This rule detects when a process executes a command line containing hexadecimal characters. Malware authors may use
hexadecimal encoding to obfuscate their payload and evade detection.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*
- logs-auditd_manager.auditd-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Execution
- Data Source: Auditd Manager
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 4
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Hex Payload Execution via Command-Line

In Linux environments, command-line interfaces are pivotal for executing processes and scripts. Adversaries exploit this by embedding payloads in hexadecimal format to obfuscate their actions, evading detection. The detection rule identifies processes with lengthy command lines containing multiple hex patterns, signaling potential obfuscation. This approach targets defense evasion tactics, leveraging Elastic Defend to flag suspicious executions.

### Possible investigation steps

- Review the process.command_line field to identify the specific hexadecimal patterns and assess if they correspond to known malicious payloads or commands.
- Examine the process.parent.executable to determine the parent process that initiated the execution, which may provide context on whether the execution is expected or suspicious.
- Check the user account associated with the process execution to verify if the activity aligns with typical user behavior or if it indicates potential compromise.
- Investigate the host where the alert was triggered to identify any other related suspicious activities or anomalies that might indicate a broader compromise.
- Correlate the event with other logs or alerts from the same host or user to identify patterns or repeated attempts at obfuscation and execution.


### False positive analysis

- Legitimate software installations or updates may use hexadecimal encoding in command lines for legitimate purposes. Users can create exceptions for known software update processes by identifying their parent executable paths and excluding them from the rule.
- System administration scripts or tools that utilize hexadecimal encoding for configuration or data processing might trigger the rule. Review and whitelist these scripts by verifying their source and purpose, then exclude them based on their command line patterns or parent processes.
- Security tools or monitoring software that perform regular scans or data collection using hexadecimal encoding could be flagged. Confirm these tools' legitimacy and add them to an exception list by specifying their executable paths or command line characteristics.
- Custom applications developed in-house that use hexadecimal encoding for data handling or communication may be mistakenly identified. Document these applications and exclude them by their unique command line signatures or parent process identifiers.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of the potential threat and to contain any malicious activity.
- Terminate the suspicious process identified by the detection rule to halt any ongoing malicious execution.
- Conduct a forensic analysis of the affected system to identify any additional indicators of compromise, such as modified files or unauthorized user accounts.
- Remove any identified malicious files or scripts from the system to ensure the threat is eradicated.
- Restore the system from a known good backup if any critical system files or configurations have been altered.
- Update and patch the system to close any vulnerabilities that may have been exploited by the adversary.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
?process.parent.executable != null and
process.command_line : "*\\x*\\x*\\x*\\x*\\x*\\x*\\x*\\x*\\x*\\x*\\x*\\x*\\x*\\x*" and
length(process.command_line) > 50 and
not process.name in ("snap", "printf", "sed")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Obfuscated Files or Information
- Id: T1027
- Reference URL: [[https://attack.mitre.org/techniques/T1027/](https://attack.mitre.org/techniques/T1027/)](https://attack.mitre.org/techniques/T1027/)
- Technique:
  - Name: Deobfuscate/Decode Files or Information
- Id: T1140
- Reference URL: [[https://attack.mitre.org/techniques/T1140/](https://attack.mitre.org/techniques/T1140/)](https://attack.mitre.org/techniques/T1140/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)
- Technique:
  - Name: User Execution
- Id: T1204
- Reference URL: [[https://attack.mitre.org/techniques/T1204/](https://attack.mitre.org/techniques/T1204/)](https://attack.mitre.org/techniques/T1204/)
- Sub Technique:
  - Name: Malicious File
- Id: T1204.002
- Reference URL: [[https://attack.mitre.org/techniques/T1204/002/](https://attack.mitre.org/techniques/T1204/002/)](https://attack.mitre.org/techniques/T1204/002/)