﻿---
title: File Deletion via Shred
description: Malware or other files dropped or created on a system by an adversary may leave traces behind as to what was done within a network and how. Adversaries...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_file_deletion_via_shred
products:
  - Elastic Security
---

# File Deletion via Shred
Malware or other files dropped or created on a system by an adversary may leave traces behind as to what was done within
a network and how. Adversaries may remove these files over the course of an intrusion to keep their footprint low or
remove them at the end as part of the post-intrusion cleanup process.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*
- logs-auditd_manager.auditd-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Auditd Manager
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Resources: Investigation Guide

**Version**: 215
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating File Deletion via Shred

The `shred` command in Linux is used to securely delete files by overwriting them, making recovery difficult. Adversaries exploit this to erase traces of malicious activity, hindering forensic analysis. The detection rule identifies suspicious use of `shred` by monitoring its execution with specific arguments, excluding benign processes like `logrotate`, to flag potential defense evasion attempts.

### Possible investigation steps

- Review the process execution details to confirm the use of the `shred` command with suspicious arguments such as "-u", "--remove", "-z", or "--zero".
- Identify the user account associated with the `shred` process to determine if the activity aligns with expected behavior for that user.
- Investigate the parent process of `shred` to ensure it is not `logrotate` and assess whether the parent process is legitimate or potentially malicious.
- Examine the timeline of events leading up to and following the `shred` execution to identify any related suspicious activities or file modifications.
- Check for any other alerts or logs related to the same host or user to identify patterns or additional indicators of compromise.
- Assess the impact of the file deletion by determining which files were targeted and whether they are critical to system operations or security.


### False positive analysis

- Logrotate processes may trigger false positives as they use shred for legitimate log file management. Exclude logrotate as a parent process in detection rules to prevent these alerts.
- System maintenance scripts that securely delete temporary files using shred can cause false positives. Identify and whitelist these scripts to reduce unnecessary alerts.
- Backup or cleanup operations that involve shredding old data might be flagged. Review and exclude these operations if they are part of routine system management.
- User-initiated file deletions for privacy or space management can appear suspicious. Educate users on the implications of using shred and consider excluding known user actions if they are frequent and benign.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further malicious activity or data exfiltration.
- Terminate any active `shred` processes that are not associated with legitimate applications like `logrotate` to halt ongoing file deletion.
- Conduct a thorough review of recent system logs and file access records to identify any additional malicious activities or files that may have been created or modified by the adversary.
- Restore any critical files that were deleted using `shred` from the most recent backup, ensuring the integrity and security of the backup source.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement enhanced monitoring on the affected system and similar environments to detect any future unauthorized use of `shred` or similar file deletion tools.
- Review and update endpoint security configurations to prevent unauthorized execution of file deletion commands by non-administrative users.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
process.name == "shred" and (
// Any short-flag cluster containing at least one of u/z, and containing no extra "-" after the first one
process.args regex~ "-[^-]*[uz][^-]*" or
process.args in ("--remove", "--zero")
) and
not process.parent.name == "logrotate"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Indicator Removal
- Id: T1070
- Reference URL: [[https://attack.mitre.org/techniques/T1070/](https://attack.mitre.org/techniques/T1070/)](https://attack.mitre.org/techniques/T1070/)
- Sub Technique:
  - Name: File Deletion
- Id: T1070.004
- Reference URL: [[https://attack.mitre.org/techniques/T1070/004/](https://attack.mitre.org/techniques/T1070/004/)](https://attack.mitre.org/techniques/T1070/004/)