﻿---
title: Curl or Wget Egress Network Connection via LoLBin
description: This rule detects the execution of curl or wget binaries through a GTFOBin (living-off-the-land) technique in Linux environments. Attackers may exploit...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_curl_or_wget_executed_via_lolbin
products:
  - Elastic Security
---

# Curl or Wget Egress Network Connection via LoLBin
This rule detects the execution of curl or wget binaries through a GTFOBin (living-off-the-land) technique in Linux
environments. Attackers may exploit these utilities to download and execute malicious files from the internet while
attempting to evade detection. The rule specifically targets binaries that are capable of executing shell commands
directly from the proxied binary, rather than just spawning a shell.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*
- logs-endpoint.events.network*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://gtfobins.github.io/#+shell](https://gtfobins.github.io/#+shell)](https://gtfobins.github.io/#+shell)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Tactic: Execution
- Tactic: Command and Control
- Tactic: Exfiltration
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 1
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Curl or Wget Egress Network Connection via LoLBin

This detects outbound connections from curl or wget when they are launched via living-off-the-land binaries that can execute shell commands, signaling proxy execution to mask activity. It matters because attackers abuse trusted utilities to fetch payloads, stage command-and-control, or exfiltrate while evading simple controls. Example: an attacker uses awk or busybox to run curl to an external host, downloads a script into /tmp, pipes it to sh, or saves a binary and runs it under the proxy’s context.

### Possible investigation steps

- Pull the full process tree around the event and review the parent LoLBin’s command line for signs of proxy execution such as pipelines to a shell, write-to-file flags (-o/-O), exfil options (--data/--upload-file), or TLS bypass (-k), noting working directory and effective user for context.
- Identify any paths or filenames used by the transfer and inspect the filesystem for newly created or modified artifacts in temp locations, recording hashes, timestamps, permission changes (e.g., chmod +x), and any immediate execution or persistence actions.
- Correlate the outbound destination with threat intelligence and internal allowlists, examine DNS/SNI/certificate details, and flag unusual ports or use of proxies/TOR that suggest evasion.
- Validate whether the parent LoLBin and its execution path align with legitimate software or maintenance workflows on the host, and broaden the search for similar executions across hosts within the same timeframe.
- Hunt for follow-on activity including new listeners, reverse shells, additional outbound beacons, or other GTFOBins invoking curl/wget, and tie findings back to the same domains/IPs or dropped filesystem artifacts.


### False positive analysis

- During legitimate dependency installation or build workflows, pip/npm/gem/bundler/yarn may run post-install hooks that invoke curl/wget to fetch supplemental files from public mirrors, with the package manager as the parent process.
- Operations or maintenance tasks may use watch/busybox/run-parts/awk to proxy execution of curl/wget for external availability checks or bootstrap downloads in init scripts, producing short-lived egress that matches the LoLBin-parent pattern.


### Response and remediation

- Immediately isolate the affected Linux host or apply an outbound block, terminate active curl/wget and their invoking LoLBins (e.g., awk, busybox, run-parts), and add temporary firewall/DNS rules to deny the contacted domain/IP and port.
- Enumerate and delete files fetched via curl/wget (-o/-O) in /tmp, /var/tmp, /dev/shm, and user home (including scripts piped to sh), remove any persistence added (new cron entries, systemd units, rc.local edits), and record hashes/paths for evidence.
- Rotate credentials or tokens exposed via -u/--header or ~/.netrc, purge malicious proxy settings and config files (http_proxy/https_proxy environment, ~/.wgetrc, ~/.curlrc), and revoke SSH keys or cookies discovered alongside the downloads.
- Restore the system by reimaging or reinstalling if tampering is suspected, re-enable egress only after validation, verify application functionality, and re-enroll the endpoint with EDR while limiting curl/wget usage to approved service accounts.
- Escalate to incident response if curl/wget is piped to a shell (e.g., curl https://...  sh), a downloaded binary is made executable and run (chmod +x followed by execution), the destination matches known malicious infrastructure, or torify/torsocks/proxy chaining is used.
- Harden by mounting /tmp, /var/tmp, and /dev/shm with noexec/nosuid/nodev, enforcing AppArmor/SELinux to restrict curl/wget network access and file writes, constraining GTFOBins from spawning shells, and requiring egress via a proxy allowlist with TLS validation (disallow --insecure/-k).


## Rule Query

```eql
sequence with maxspan=3s
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and process.name in (
     "aa-exec", "aoss", "awk", "run-parts", "bundle", "bundler", "busctl", "busybox", "byebug", "c89", "c99", "cabal",
     "capsh", "cdist", "certbot", "check_by_ssh", "choom", "cobc", "cowsay", "cowthink", "cpio", "cpulimit", "csvtool",
     "dc", "distcc", "easy_install", "emacs", "enscript", "expect", "find", "flock", "gawk", "gcc", "gdb", "gem",
     "genie", "ghc", "ghci", "gimp", "grc", "gtester", "ionice", "irb", "jjs", "jrunscript", "knife", "latex",
     "latexmk", "lftp", "logsave", "ltrace", "mail", "mawk", "msgfilter", "multitime", "mysql", "nawk", "neofetch",
     "nice", "nohup", "npm", "nroff", "nsenter", "octave", "openvpn", "pandoc", "pdb", "pdflatex", "pdftex", "perf",
     "pexec", "pip", "rake", "rc", "rlwrap", "rpmdb", "rpmquery", "rpmverify", "rsync", "rtorrent", "runscript",
     "rview", "rvim", "script", "scrot", "sed", "service", "setarch", "setlock", "sg", "socat", "softlimit", "split",
     "sqlite3", "sqlmap", "sshpass", "start-stop-daemon", "stdbuf", "tar", "taskset",
     "tasksh", "tex", "time", "tmate", "torify", "torsocks", "tshark", "valgrind", "vi", "view",
     "vim", "vimdiff", "watch", "xdg-user-dir", "xdotool", "xelatex", "xetex", "yarn", "zip", "zypper"
   ) and not (
     process.executable == "/tmp/newroot/unshare" or
     process.parent.args in (
       "/etc/.agent/server_agent.sh", "/nessus/update2.sh", "/etc/cron.daily/spamassassin", "/etc/cron.daily/rkhunter",
       "buildkit-runc", "/usr/sbin/spamassassin-maint"
     ) or
     process.parent.executable like (
       "/usr/local/bin/fail2ban_cluster.sh", "/script/downloadArtifacts.sh", "/etc/cron.daily/rkhunter",
       "/usr/bin/bbb-conf", "/usr/sbin/sos", "/usr/bin/make", "/var/lib/amagent/*", "/etc/cron.daily/spamassassin",
       "/usr/lib/cron/run-crons", "/usr/sbin/spamassassin-maint", "/usr/sbin/oracle-libs-update"
     ) or
     process.parent.name in ("rkhunter", "vivaldi-stable.postinst", "runc") or
     process.parent.command_line == "runc init" or
     process.parent.command_line like "/home/*/bin/DownloadExchangeFiles_mcx*" or
     process.command_line in (
       "nice -10 /opt/aws/discovery/update", "xargs -n 1 curl -o lpsc -L", "/usr/bin/ruby /usr/bin/rake run:server_hooks",
       "nohup ./update2.sh"
     ) or
     process.parent.command_line in ("/bin/sh -c nice -n 15 $HOME/bin/cron.pl > /dev/null 2>&1", "/bin/sh /etc/cron.daily/rkhunter") or
     process.command_line like ("*/home/linuxbrew/.linuxbrew/*", "*Homebrew*", "*webhook*") or
     process.args like ("/usr/lib/jvm/*", "/root/.forge/provision-*.sh", "/usr/src/ucrm/scripts/update-certificates.sh", "/etc/periodic/weekly/update_mmdb.sh") or
     (process.name == "nohup" and process.command_line like "nohup /usr/*/*.sh") or
     (process.name == "julia" and process.parent.name == "julia")
   )
  ] by process.entity_id
  [network where host.os.type == "linux" and event.type == "start" and event.action == "connection_attempted" and
   process.name in ("wget", "curl") and not (
     destination.ip == null or destination.ip == "0.0.0.0" or cidrmatch(
       destination.ip, "10.0.0.0/8", "127.0.0.0/8", "169.254.0.0/16", "172.16.0.0/12", "192.0.0.0/24", "192.0.0.0/29",
       "192.0.0.8/32", "192.0.0.9/32", "192.0.0.10/32", "192.0.0.170/32", "192.0.0.171/32", "192.0.2.0/24",
       "192.31.196.0/24", "192.52.193.0/24", "192.168.0.0/16", "192.88.99.0/24", "224.0.0.0/4", "100.64.0.0/10",
       "192.175.48.0/24","198.18.0.0/15", "198.51.100.0/24", "203.0.113.0/24", "240.0.0.0/4", "::1", "FE80::/10",
       "FF00::/8"
     )
   )
  ] by process.parent.entity_id
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: System Binary Proxy Execution
- Id: T1218
- Reference URL: [[https://attack.mitre.org/techniques/T1218/](https://attack.mitre.org/techniques/T1218/)](https://attack.mitre.org/techniques/T1218/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Command and Control
- Id: TA0011
- Reference URL: [[https://attack.mitre.org/tactics/TA0011/](https://attack.mitre.org/tactics/TA0011/)](https://attack.mitre.org/tactics/TA0011/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Exfiltration
- Id: TA0010
- Reference URL: [[https://attack.mitre.org/tactics/TA0010/](https://attack.mitre.org/tactics/TA0010/)](https://attack.mitre.org/tactics/TA0010/)