﻿---
title: File made Immutable by Chattr
description: Detects a file being made immutable using the chattr binary. Making a file immutable means it cannot be deleted or renamed, no link can be created to...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_chattr_immutable_file
products:
  - Elastic Security
---

# File made Immutable by Chattr
Detects a file being made immutable using the chattr binary. Making a file immutable means it cannot be deleted or
renamed, no link can be created to this file, most of the file's metadata can not be modified, and the file can not be
opened in write mode. Threat actors will commonly utilize this to prevent tampering or modification of their malicious
files or any system files they have modified for purposes of persistence (e.g .ssh, /etc/passwd, etc.).
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-auditd_manager.auditd-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 33
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Endgame
- Data Source: Elastic Defend
- Data Source: SentinelOne
- Data Source: Auditd Manager
- Data Source: Crowdstrike
- Resources: Investigation Guide

**Version**: 217
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from one of the following integrations:
- Elastic Defend
- Auditbeat


### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


### Auditbeat Setup

Auditbeat is a lightweight shipper that you can install on your servers to audit the activities of users and processes on your systems. For example, you can use Auditbeat to collect and centralize audit events from the Linux Audit Framework. You can also use Auditbeat to detect changes to critical files, like binaries and configuration files, and identify potential security policy violations.

#### The following steps should be executed in order to add the Auditbeat on a Linux System:

- Elastic provides repositories available for APT and YUM-based distributions. Note that we provide binary packages, but no source packages.
- To install the APT and YUM repositories follow the setup instructions in this [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setup-repositories.html).
- To run Auditbeat on Docker follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-docker.html).
- To run Auditbeat on Kubernetes follow the setup instructions in the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/running-on-kubernetes.html).
- For complete “Setup and Run Auditbeat” information refer to the [helper guide](https://www.elastic.co/guide/en/beats/auditbeat/current/setting-up-and-running.html).


#### Custom Ingest Pipeline

For versions <8.2, you need to add a custom ingest pipeline to populate `event.ingested` with @timestamp for non-elastic-agent indexes, like auditbeats/filebeat/winlogbeat etc. For more details to add a custom ingest pipeline refer to the [guide](https://www.elastic.co/guide/en/fleet/current/data-streams-pipeline-tutorial.html).

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating File made Immutable by Chattr

The `chattr` command in Linux is used to change file attributes, including making files immutable, which prevents modifications or deletions. Adversaries exploit this to secure malicious files or altered system files against tampering, aiding persistence. The detection rule identifies suspicious use of `chattr` by monitoring process executions, filtering out benign parent processes, and focusing on those altering immutability attributes, thus highlighting potential misuse.

### Possible investigation steps

- Review the process execution details to confirm the use of the chattr command with arguments altering immutability, specifically looking for "+i" or "-i" in process.args.
- Identify the file(s) targeted by the chattr command to determine if they are critical system files or files commonly targeted by threat actors, such as .ssh or /etc/passwd.
- Investigate the parent process of the chattr execution by examining process.parent.executable and process.parent.name to determine if it is a known benign process or potentially malicious.
- Check the user context under which the chattr command was executed to assess if it aligns with expected administrative activity or if it indicates unauthorized access.
- Correlate the event with other security alerts or logs to identify any related suspicious activities, such as unauthorized access attempts or changes to other system files.
- Evaluate the risk and impact of the immutable file(s) on system operations and security posture, considering the potential for persistence or defense evasion by threat actors.


### False positive analysis

- System processes like systemd and cf-agent may invoke chattr for legitimate reasons, such as system maintenance or configuration management. To handle these, exclude these processes by adding them to the exception list in the detection rule.
- Scheduled tasks or scripts that use chattr to manage file attributes for security or operational purposes can trigger false positives. Identify these tasks and exclude their parent processes from the rule.
- Administrative actions performed by authorized users, such as securing configuration files, might be flagged. Regularly review and update the list of known benign parent processes to prevent unnecessary alerts.
- Security tools or agents that modify file attributes as part of their protection mechanisms can cause false positives. Ensure these tools are recognized and excluded by their executable paths or parent process names.


### Response and remediation

- Isolate the affected system from the network to prevent further spread or communication with potential command and control servers.
- Identify and terminate any malicious processes associated with the `chattr` command to stop further unauthorized file modifications.
- Restore the affected files from a known good backup, ensuring that any immutable attributes set by the attacker are removed.
- Conduct a thorough review of user accounts and permissions on the affected system to ensure no unauthorized access or privilege escalation has occurred.
- Implement file integrity monitoring to detect unauthorized changes to critical system files, enhancing detection capabilities for similar threats.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems are compromised.
- Review and update security policies and configurations to prevent unauthorized use of the `chattr` command, such as restricting its execution to trusted administrators only.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and
event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
?process.parent.executable != null and
process.name == "chattr" and process.args : ("-*i*", "+*i*") and
not (
  ?process.parent.executable: (
    "/lib/systemd/systemd", "/usr/local/uems_agent/bin/*", "/usr/lib/systemd/systemd", "/usr/local/emps/sbin/php-fpm",
    "/usr/local/emps/bin/php"
  ) or
  ?process.parent.name in (
    "systemd", "cf-agent", "ntpdate", "xargs", "px", "preinst", "auth", "cf-agent", "dcservice", "dcagentupgrader",
    "sudo", "ephemeral-disk-warning"
  ) or
  process.args like "/opt/ai-bolit/*"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: File and Directory Permissions Modification
- Id: T1222
- Reference URL: [[https://attack.mitre.org/techniques/T1222/](https://attack.mitre.org/techniques/T1222/)](https://attack.mitre.org/techniques/T1222/)
- Sub Technique:
  - Name: Linux and Mac File and Directory Permissions Modification
- Id: T1222.002
- Reference URL: [[https://attack.mitre.org/techniques/T1222/002/](https://attack.mitre.org/techniques/T1222/002/)](https://attack.mitre.org/techniques/T1222/002/)