﻿---
title: System Binary Moved or Copied
description: This rule monitors for the copying or moving of a system binary. Adversaries may copy/move and rename system binaries to evade detection. Copying a system...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_binary_copied_to_suspicious_directory
products:
  - Elastic Security
---

# System Binary Moved or Copied
This rule monitors for the copying or moving of a system binary. Adversaries may copy/move and rename system binaries to
evade detection. Copying a system binary to a different location should not occur often, so if it does, the activity
should be investigated.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.file*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://intezer.com/blog/research/kaiji-new-chinese-linux-malware-turning-to-golang/](https://intezer.com/blog/research/kaiji-new-chinese-linux-malware-turning-to-golang/)](https://intezer.com/blog/research/kaiji-new-chinese-linux-malware-turning-to-golang/)
- [[https://www.elastic.co/security-labs/sequel-on-persistence-mechanisms](https://www.elastic.co/security-labs/sequel-on-persistence-mechanisms)](https://www.elastic.co/security-labs/sequel-on-persistence-mechanisms)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 18
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating System Binary Moved or Copied

System binaries are essential executables in Linux environments, crucial for system operations. Adversaries may move or copy these binaries to alternate locations to evade detection, often renaming them to blend in with legitimate processes. The detection rule identifies unusual movements or copies of these binaries, excluding common system processes and paths, to flag potential malicious activity. This helps in identifying attempts at masquerading, a tactic used to bypass security measures.

### Possible investigation steps

- Review the file path and name in the alert to determine if the binary was moved or copied to a suspicious or unusual location, which could indicate an attempt to masquerade.
- Examine the process name and executable path that triggered the alert to identify if it is associated with known legitimate processes or if it appears suspicious or unexpected.
- Check the user account associated with the process to determine if the action was performed by a privileged or unauthorized user, which could suggest malicious intent.
- Investigate the historical activity of the process and user involved to identify any patterns or previous suspicious behavior that might correlate with the current alert.
- Correlate the alert with other security events or logs from the same timeframe to identify any related activities or anomalies that could provide additional context or evidence of malicious activity.


### False positive analysis

- System updates and package installations often involve legitimate movement or copying of binaries. Exclude processes like dpkg, rpm, and apt-get from triggering alerts by adding them to the exception list.
- Development and testing environments may frequently rename or move binaries for testing purposes. Consider excluding paths like /tmp or /dev/fd from monitoring if they are commonly used for non-malicious activities.
- Automated scripts or configuration management tools such as Puppet or Chef may move binaries as part of their normal operations. Add these tools to the exception list to prevent unnecessary alerts.
- Temporary files created during software installations or updates, such as those with extensions like .tmp or .dpkg-new, can trigger false positives. Exclude these extensions from monitoring to reduce noise.
- Custom scripts or applications that mimic system processes for legitimate reasons might be flagged. Review and whitelist these specific scripts or applications if they are verified as non-threatening.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement by the adversary.
- Terminate any suspicious processes identified in the alert that are associated with the unauthorized movement or copying of system binaries.
- Restore any altered or moved system binaries to their original locations and verify their integrity using known good backups or checksums.
- Conduct a thorough review of system logs and the alert details to identify any additional indicators of compromise or related malicious activity.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement additional monitoring on the affected system and similar environments to detect any recurrence of the activity, focusing on the specific paths and processes identified in the alert.
- Review and update access controls and permissions to ensure that only authorized users and processes can modify or move system binaries, reducing the risk of similar incidents in the future.


## Rule Query

```eql
file where host.os.type == "linux" and event.action in ("rename", "creation") and process.name in ("cp", "mv") and
file.Ext.original.path : (
  "/bin/*", "/usr/bin/*", "/usr/local/bin/*", "/sbin/*", "/usr/sbin/*", "/usr/local/sbin/*"
) and not (
  file.Ext.original.path : (
    "/bin/*.tmp", "/usr/bin/*.tmp", "/usr/local/bin/*.tmp", "/sbin/*.tmp", "/usr/sbin/*.tmp", "/usr/local/sbin/*.tmp"
  ) or
  file.extension in ("swp", "swpx", "swx", "dpkg-remove") or
  file.Ext.original.extension == "dpkg-new" or
  process.executable : ("/nix/store/*", "/var/lib/dpkg/*", "/tmp/vmis.*", "/snap/*", "/dev/fd/*", "/tmp/newroot/*")
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Rename Legitimate Utilities
- Id: T1036.003
- Reference URL: [[https://attack.mitre.org/techniques/T1036/003/](https://attack.mitre.org/techniques/T1036/003/)](https://attack.mitre.org/techniques/T1036/003/)
- Technique:
  - Name: Hide Artifacts
- Id: T1564
- Reference URL: [[https://attack.mitre.org/techniques/T1564/](https://attack.mitre.org/techniques/T1564/)](https://attack.mitre.org/techniques/T1564/)