﻿---
title: Unusual Base64 Encoding/Decoding Activity
description: This rule leverages ESQL to detect unusual base64 encoding/decoding activity on Linux systems. Attackers may use base64 encoding/decoding to obfuscate...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/defense_evasion_base64_decoding_activity
products:
  - Elastic Security
---

# Unusual Base64 Encoding/Decoding Activity
This rule leverages ESQL to detect unusual base64 encoding/decoding activity on Linux systems. Attackers may use base64
encoding/decoding to obfuscate data, such as command and control traffic or payloads, to evade detection by host- or
network-based security controls. ESQL rules have limited fields available in its alert documents. Make sure to review
the original documents to aid in the investigation of this alert.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 1h
**Searches indices from**: `now-61m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 8
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from one of the following integrations:
- Elastic Defend


### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Unusual Base64 Encoding/Decoding Activity

Base64 encoding is a method to convert binary data into ASCII text, often used for data transmission. Adversaries exploit this to obfuscate malicious payloads or commands, bypassing security controls. The detection rule identifies suspicious Base64 activity on Linux by monitoring specific processes and command patterns, flagging anomalies for further investigation.

### Possible investigation steps

- Review the process name and command line arguments to understand the context of the Base64 activity. Check if the process name matches known legitimate applications or scripts.
- Examine the timestamp of the event to determine if the activity occurred during normal operational hours or if it coincides with other suspicious activities.
- Investigate the host operating system type and agent ID to identify the specific Linux system involved and assess if it has a history of similar alerts or other security incidents.
- Analyze the process command line for any unusual patterns or parameters that might indicate obfuscation or malicious intent, such as the presence of decode flags or unexpected Base64 operations.
- Correlate the event with other logs or alerts from the same host or network to identify potential lateral movement or coordinated attacks.
- Check for any recent changes or deployments on the affected system that might explain the Base64 activity, such as new software installations or updates.
- Consult threat intelligence sources to determine if the observed Base64 patterns or command line arguments are associated with known malware or attack techniques.


### False positive analysis

- Routine administrative scripts may use base64 encoding for legitimate data processing tasks. Review the process.command_line and process.args fields to identify known scripts and consider excluding them from the rule.
- Backup or data transfer operations might employ base64 encoding to handle binary data. Verify the process.name and process.command_line to ensure these operations are recognized and add exceptions for these specific processes.
- Development environments often use base64 encoding for testing purposes. Identify development-related processes by examining the process.name and process.command_line and exclude them if they are part of regular development activities.
- Automated system monitoring tools might trigger this rule if they use base64 encoding for log or data analysis. Check the agent.id and process.command_line to confirm these tools and exclude them from the rule if they are verified as non-threatening.
- Security tools that perform data encoding for analysis or reporting could be flagged. Validate these tools by reviewing the process.name and process.command_line and create exceptions for them if they are part of the security infrastructure.


### Response and remediation

- Isolate the affected Linux system from the network to prevent further data exfiltration or lateral movement by the adversary.
- Terminate any suspicious processes identified by the alert, particularly those involving base64 encoding/decoding, to halt potential malicious activity.
- Conduct a thorough review of the process command lines and arguments flagged by the alert to identify any malicious scripts or payloads. Remove or quarantine these files as necessary.
- Check for any unauthorized user accounts or privilege escalations that may have been established during the attack and revoke access immediately.
- Restore any affected systems or files from a known good backup to ensure the integrity of the system and data.
- Implement additional monitoring on the affected system and similar environments to detect any recurrence of the suspicious base64 activity.
- Escalate the incident to the security operations center (SOC) or incident response team for further analysis and to determine if broader organizational impacts exist.


## Rule Query

```esql
from logs-endpoint.events.process-* metadata _id, _index, _version
| mv_expand event.action 
| where
    host.os.type == "linux" and
    event.type == "start" and
    event.action == "exec" and (
        (
            process.name in ("base64", "base64plain", "base64url", "base64mime", "base64pem", "base32", "base16") and
            process.command_line like "*-*d*"
        ) or
        (
            process.name == "openssl" and
            process.args == "enc" and
            process.args in ("-d", "-base64", "-a")
        ) or
        (
            process.name like "python*" and (
                (
                    process.args == "base64" and
                    process.args in ("-d", "-u", "-t")
                ) or
                (
                    process.args == "-c" and
                    process.command_line like "*base64*" and
                    process.command_line like "*b64decode*"
                )
            )
        ) or
        (
            process.name like "perl*" and
            process.command_line like "*decode_base64*"
        ) or
        (
            process.name like "ruby*" and
            process.args == "-e" and
            process.command_line like "*Base64.decode64*"
        )
    )
| keep
    @timestamp,
    _id,
    _index,
    _version,
    host.os.type,
    event.type,
    event.action,
    process.name,
    process.args,
    process.command_line,
    process.parent.name,
    process.parent.command_line,
    agent.id,
    host.name,
    event.dataset,
    data_stream.namespace
| stats
    Esql.event_count = count(),
    Esql.process_parent_name_values = values(process.parent.name),
    Esql.process_parent_command_line_values = values(process.parent.command_line),
    Esql.agent_id_count_distinct = count_distinct(agent.id),
    Esql.host_name_values = values(host.name),
    Esql.agent_id_values = values(agent.id),
    Esql.event_dataset_values = values(event.dataset),
    Esql.data_stream_namespace_values = values(data_stream.namespace)
    by process.name, process.command_line
| where
    Esql.agent_id_count_distinct == 1 and
    Esql.event_count < 15
| sort Esql.event_count asc

// Extract unique values to ECS fields for alerts exclusion
| eval agent.id = mv_min(Esql.agent_id_values),
       host.name = mv_min(Esql.host_name_values)

| keep agent.id, host.name, process.name, process.command_line, Esql.*
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Obfuscated Files or Information
- Id: T1027
- Reference URL: [[https://attack.mitre.org/techniques/T1027/](https://attack.mitre.org/techniques/T1027/)](https://attack.mitre.org/techniques/T1027/)
- Technique:
  - Name: Deobfuscate/Decode Files or Information
- Id: T1140
- Reference URL: [[https://attack.mitre.org/techniques/T1140/](https://attack.mitre.org/techniques/T1140/)](https://attack.mitre.org/techniques/T1140/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Execution
- Id: TA0002
- Reference URL: [[https://attack.mitre.org/tactics/TA0002/](https://attack.mitre.org/tactics/TA0002/)](https://attack.mitre.org/tactics/TA0002/)
- Technique:
  - Name: Command and Scripting Interpreter
- Id: T1059
- Reference URL: [[https://attack.mitre.org/techniques/T1059/](https://attack.mitre.org/techniques/T1059/)](https://attack.mitre.org/techniques/T1059/)
- Sub Technique:
  - Name: Unix Shell
- Id: T1059.004
- Reference URL: [[https://attack.mitre.org/techniques/T1059/004/](https://attack.mitre.org/techniques/T1059/004/)](https://attack.mitre.org/techniques/T1059/004/)
- Technique:
  - Name: User Execution
- Id: T1204
- Reference URL: [[https://attack.mitre.org/techniques/T1204/](https://attack.mitre.org/techniques/T1204/)](https://attack.mitre.org/techniques/T1204/)
- Sub Technique:
  - Name: Malicious File
- Id: T1204.002
- Reference URL: [[https://attack.mitre.org/techniques/T1204/002/](https://attack.mitre.org/techniques/T1204/002/)](https://attack.mitre.org/techniques/T1204/002/)