﻿---
title: Potential SSH Password Grabbing via strace
description: Detects potential SSH password grabbing via the use of strace on sshd processes. Attackers may use strace to capture sensitive information, such as passwords,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_ssh_password_grabbing_via_strace
products:
  - Elastic Security
---

# Potential SSH Password Grabbing via strace
Detects potential SSH password grabbing via the use of strace on sshd processes. Attackers may use strace to capture
sensitive information, such as passwords, by tracing system calls made by the sshd process. This rule looks for a sequence
of events where an sshd process ends followed closely by the start of a strace process. This may be indicative of an attacker
attempting to capture SSH credentials.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/braindead-sec/ssh-grabber](https://github.com/braindead-sec/ssh-grabber)](https://github.com/braindead-sec/ssh-grabber)
- [[https://dfir.ch/posts/strace/](https://dfir.ch/posts/strace/)](https://dfir.ch/posts/strace/)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Persistence
- Tactic: Credential Access
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 2
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential SSH Password Grabbing via strace

This detection flags a suspicious sequence where an sshd process stops and a strace process starts seconds later, indicating attempted snooping of SSH authentication. Capturing syscall activity around login exposes passwords and session secrets, enabling credential theft and lateral movement. Attackers kill sshd, then relaunch or attach with strace, logging read/write and open calls from PAM or keyboard-interactive flows to a file such as /tmp/sshd.trace.

### Possible investigation steps

- Pull the strace command-line, full path, parent chain, invoking user, and working directory to confirm whether it attached to sshd and whether output was directed to a file.
- Correlate systemd/journald and audit logs around the same seconds for sshd stop/start, kill signals, coredumps, or admin actions to distinguish debugging from credential capture.
- Identify and preserve any strace output or redirected logs (common in /tmp or home directories) and scan for PAM interactions or TTY reads containing password prompts.
- Check ptrace feasibility by verifying UID relationships, CAP_SYS_PTRACE, SELinux/AppArmor policies, and ptrace_scope to assess whether sshd could be traced.
- Pivot on the same user and host for adjacent activity such as restarting sshd, running ltrace/gdb/perf, modifying PAM or sshd_config, and creating trace files to gauge intent.


### False positive analysis

- An administrator intentionally stops sshd and immediately launches strace to troubleshoot a configuration change or startup problem, tracing a controlled test run rather than attempting to capture credentials.
- A normal sshd session process ends while strace is started to debug an unrelated application, producing a near-simultaneous end/start sequence even though strace is not attached to sshd or capturing authentication input.


### Response and remediation

- Immediately kill active strace processes targeting sshd (e.g., strace -p PID or strace -f /usr/sbin/sshd with -o /tmp/sshd.trace), isolate the host from the network, and restart the sshd service to restore a clean state.
- Preserve forensic copies, then remove artifacts such as trace outputs like /tmp/sshd.trace or ~/sshd.strace.log, purge unauthorized strace wrappers or cron entries, and revert changes in /etc/ssh/sshd_config and /etc/pam.d/*.
- Force credential hygiene by expiring passwords for users who logged in during the suspected window, rotating SSH host keys in /etc/ssh/ (ssh_host_*), revoking recently added ~/.ssh/authorized_keys entries, and terminating lingering sshd child sessions and SSH agents in /tmp or /run.
- Escalate to incident response if strace was executed as root or via sudo against /usr/sbin/sshd, if CAP_SYS_PTRACE or ptrace_scope=0 was present, if trace files contain password strings or PAM conversation data, or if similar behavior appears on more than one host.
- Harden by setting /proc/sys/kernel/yama/ptrace_scope to 1 or 2, enforcing SELinux/AppArmor policies that block ptrace to sshd, disabling PasswordAuthentication or requiring MFA in /etc/ssh/sshd_config, and adding auditd rules to alert on ptrace attaches to /usr/sbin/sshd.


## Rule Query

```eql
sequence by host.id with maxspan=3s
  [process where host.os.type == "linux" and event.type == "end" and process.name == "sshd"]
  [process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and process.name == "strace"]
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Modify Authentication Process
- Id: T1556
- Reference URL: [[https://attack.mitre.org/techniques/T1556/](https://attack.mitre.org/techniques/T1556/)](https://attack.mitre.org/techniques/T1556/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Compromise Host Software Binary
- Id: T1554
- Reference URL: [[https://attack.mitre.org/techniques/T1554/](https://attack.mitre.org/techniques/T1554/)](https://attack.mitre.org/techniques/T1554/)