﻿---
title: Potential Linux Local Account Brute Force Detected
description: Identifies multiple consecutive login attempts executed by one process targeting a local linux user account within a short time interval. Adversaries...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_potential_linux_local_account_bruteforce
products:
  - Elastic Security
---

# Potential Linux Local Account Brute Force Detected
Identifies multiple consecutive login attempts executed by one process targeting a local linux user account within a
short time interval. Adversaries might brute force login attempts across different users with a default wordlist or a
set of customly crafted passwords in an attempt to gain access to these accounts.
**Rule type**: esql
**Rule indices**:
**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 8m
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 12
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Potential Linux Local Account Brute Force Detected

In Linux environments, the 'su' command is used to switch user accounts, often requiring a password. Adversaries exploit this by attempting numerous logins with various passwords to gain unauthorized access. The detection rule identifies suspicious activity by monitoring rapid, repeated 'su' command executions from a single process, excluding common legitimate parent processes, indicating potential brute force attempts.

### Possible investigation steps

- Review the process execution details to identify the parent process of the 'su' command, focusing on any unusual or unauthorized parent processes not listed in the exclusion list.
- Analyze the frequency and pattern of the 'su' command executions from the identified process to determine if they align with typical user behavior or indicate a brute force attempt.
- Check the user account targeted by the 'su' command attempts to assess if it is a high-value or sensitive account that might be of interest to adversaries.
- Investigate the source host (host.id) to determine if there are any other suspicious activities or anomalies associated with it, such as unusual network connections or other security alerts.
- Correlate the event timestamps with other logs or alerts to identify any concurrent suspicious activities that might indicate a coordinated attack effort.


### False positive analysis

- Legitimate administrative scripts or automation tools may trigger the rule if they execute the 'su' command frequently. To mitigate this, identify and whitelist these scripts or tools by adding their parent process names to the exclusion list.
- Scheduled tasks or cron jobs that require switching users might be misidentified as brute force attempts. Review and exclude these tasks by specifying their parent process names in the exclusion criteria.
- Development or testing environments where frequent user switching is part of normal operations can generate false positives. Consider excluding these environments from monitoring or adjust the detection threshold to better fit the operational context.
- Continuous integration or deployment systems that use the 'su' command for user context switching can be mistaken for brute force attempts. Add these systems' parent process names to the exclusion list to prevent false alerts.


### Response and remediation

- Immediately isolate the affected host to prevent further unauthorized access or lateral movement within the network.
- Terminate the suspicious process identified by the detection rule to stop ongoing brute force attempts.
- Reset passwords for the targeted user accounts to prevent unauthorized access using potentially compromised credentials.
- Review and update the password policy to enforce strong, complex passwords and consider implementing account lockout mechanisms after a certain number of failed login attempts.
- Conduct a thorough review of the affected system for any signs of successful unauthorized access or additional malicious activity, such as new user accounts or scheduled tasks.
- Escalate the incident to the security operations team for further investigation and to determine if additional systems may be affected.
- Enhance monitoring and logging on the affected host and similar systems to detect and respond to future brute force attempts more effectively.


## Rule Query

```esql
from logs-endpoint.events.process* metadata _id, _index, _version

// Create 1-minute time buckets
| eval Esql.time_window_date_trunc = date_trunc(1 minute, @timestamp)

// Ensure event.action values in a list are expanded
| mv_expand event.action 

| where
  event.category == "process" and event.type == "start" and event.action == "exec" and process.name == "su" and 
  process.parent.name not in (
    "bash", "dash", "ash", "sh", "tcsh", "csh", "zsh", "ksh", "fish", "clickhouse-server", "ma", "gitlab-runner",
    "updatedb.findutils", "cron", "perl", "sudo", "java", "cloud-app-identify", "ambari-sudo.sh", "runc",
    "cau9sat.exe", "git-pull.sh", "distributor-pulltabs-devel-live", "p_ctmag", "backup_agent_main", "sshd",
    "nxpgsql", "cau9cli.exe", "autopostgresqlbackup"
  ) and
  not process.parent.command_line == "runc init"

// Keep relevant fields
| keep
   @timestamp,
   event.action,
   event.category,
   event.type,
   process.name,
   process.parent.name,
   process.parent.command_line,
   process.command_line,
   user.name,
   event.dataset,
   data_stream.namespace,
   process.parent.executable,
   agent.id,
   user.id,
   Esql.time_window_date_trunc

| stats
  Esql.event_count = count(*),
  Esql.process_command_line_values = values(process.command_line),
  Esql.process_parent_command_line_values = values(process.parent.command_line),
  Esql.user_name_values = values(user.name),
  Esql.event_dataset_values = values(event.dataset),
  Esql.data_stream_namespace_values = values(data_stream.namespace)

  by process.parent.executable, agent.id, user.id, Esql.time_window_date_trunc

| where Esql.event_count >= 10
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Brute Force
- Id: T1110
- Reference URL: [[https://attack.mitre.org/techniques/T1110/](https://attack.mitre.org/techniques/T1110/)](https://attack.mitre.org/techniques/T1110/)
- Sub Technique:
  - Name: Password Guessing
- Id: T1110.001
- Reference URL: [[https://attack.mitre.org/techniques/T1110/001/](https://attack.mitre.org/techniques/T1110/001/)](https://attack.mitre.org/techniques/T1110/001/)