﻿---
title: Manual Memory Dumping via Proc Filesystem
description: This rule monitors for manual memory dumping via the proc filesystem. The proc filesystem in Linux provides a virtual filesystem that contains information...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_manual_memory_dumping
products:
  - Elastic Security
---

# Manual Memory Dumping via Proc Filesystem
This rule monitors for manual memory dumping via the proc filesystem. The proc filesystem in Linux provides a virtual filesystem
that contains information about system processes and their memory mappings. Attackers may use this technique to dump the memory
of a process, potentially extracting sensitive information such as credentials or encryption keys.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-auditd_manager.auditd-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Use Case: Vulnerability
- Data Source: Elastic Defend
- Data Source: SentinelOne
- Data Source: Crowdstrike
- Data Source: Elastic Endgame
- Data Source: Auditd Manager
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Manual Memory Dumping via Proc Filesystem

The proc filesystem in Linux is a virtual interface providing detailed insights into system processes and their memory. Adversaries exploit this by manually dumping memory from processes to extract sensitive data like credentials. The detection rule identifies suspicious activities by monitoring process executions that access memory files within the proc directory, flagging potential credential access attempts.

### Possible investigation steps

- Review the alert details to identify the specific process name and command line that triggered the rule, focusing on processes like "cat", "grep", "tail", "less", "more", "egrep", or "fgrep" accessing "/proc/*/mem".
- Examine the process execution context, including the parent process and user account associated with the suspicious activity, to determine if the activity is expected or potentially malicious.
- Check the system logs and historical data for any previous occurrences of similar activities involving the same process names and command lines to assess if this is part of a pattern or anomaly.
- Investigate the user account's recent activities and permissions to determine if there are any signs of compromise or unauthorized access that could explain the memory dumping attempt.
- Analyze network traffic and connections from the host to identify any potential data exfiltration attempts or communications with known malicious IP addresses or domains.
- If necessary, isolate the affected system to prevent further potential data leakage and conduct a deeper forensic analysis to uncover any additional indicators of compromise.


### False positive analysis

- System administrators or automated scripts may legitimately access the proc filesystem for monitoring or debugging purposes. To handle this, identify and whitelist known scripts or administrative tools that frequently access memory files.
- Security tools or monitoring solutions might access the proc filesystem as part of their regular operations. Review and exclude these processes from the rule to prevent unnecessary alerts.
- Developers or testers might use commands like cat or grep on proc files during application debugging. Establish a list of approved users or groups who are allowed to perform these actions and exclude their activities from triggering alerts.
- Backup or system maintenance processes could involve accessing proc files. Document these processes and create exceptions for them to avoid false positives.
- Regular system health checks might involve accessing memory files. Identify these checks and configure the rule to ignore them by specifying the associated process names or command patterns.


### Response and remediation

- Immediately isolate the affected system to prevent further unauthorized access or data exfiltration. Disconnect the network connection and disable remote access capabilities.
- Terminate any suspicious processes identified by the detection rule, specifically those accessing memory files within the proc directory using commands like "cat", "grep", "tail", "less", "more", "egrep", or "fgrep".
- Conduct a memory analysis on the isolated system to identify any extracted sensitive data, such as credentials or encryption keys, and assess the extent of the compromise.
- Change all potentially compromised credentials and encryption keys immediately, prioritizing those associated with critical systems and services.
- Review and enhance system logging and monitoring configurations to ensure comprehensive visibility into process activities, particularly those involving the proc filesystem.
- Escalate the incident to the security operations center (SOC) or relevant cybersecurity team for further investigation and to determine if the threat is part of a larger attack campaign.
- Implement additional security controls, such as restricting access to the proc filesystem and employing application whitelisting, to prevent unauthorized memory dumping activities in the future.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
process.name in ("cat", "grep", "tail", "less", "more", "egrep", "fgrep") and process.command_line like "/proc/*/mem"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: Proc Filesystem
- Id: T1003.007
- Reference URL: [[https://attack.mitre.org/techniques/T1003/007/](https://attack.mitre.org/techniques/T1003/007/)](https://attack.mitre.org/techniques/T1003/007/)
- Technique:
  - Name: Exploitation for Credential Access
- Id: T1212
- Reference URL: [[https://attack.mitre.org/techniques/T1212/](https://attack.mitre.org/techniques/T1212/)](https://attack.mitre.org/techniques/T1212/)