﻿---
title: Kubernetes Service Account Secret Access
description: This rule detects when a process accesses Kubernetes service account secrets. Kubernetes service account secrets are files that contain sensitive information...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_kubernetes_service_account_secret_access
products:
  - Elastic Security
---

# Kubernetes Service Account Secret Access
This rule detects when a process accesses Kubernetes service account secrets. Kubernetes service
account secrets are files that contain sensitive information used by applications running in Kubernetes
clusters to authenticate and authorize access to the cluster. These secrets are typically mounted into
pods at runtime, allowing applications to access them securely. Unauthorized access to these secrets
can lead to privilege escalation, lateral movement and unauthorized actions within the cluster.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
**Tags**:
- Domain: Endpoint
- Domain: Container
- Domain: Kubernetes
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Tactic: Discovery
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Kubernetes Service Account Secret Access

Kubernetes service account secrets are crucial for authenticating applications within clusters, providing access to necessary resources. Adversaries may exploit these secrets to escalate privileges or move laterally within the cluster. The detection rule identifies unauthorized access by monitoring processes that interact with secret file paths or specific secret files, flagging potential misuse for further investigation.

### Possible investigation steps

- Review the process command line and working directory to confirm if the access to the service account secrets was expected or authorized. Check for any known applications or scripts that should have access to these paths.
- Investigate the user or service account under which the process was executed to determine if it has legitimate reasons to access the Kubernetes service account secrets.
- Examine the process arguments, specifically looking for access to files like "ca.crt", "token", and "namespace", to understand the nature of the access and whether it aligns with normal operations.
- Check the history of the process and any associated processes to identify if there are any patterns of unauthorized access or if this is an isolated incident.
- Correlate the event with other logs or alerts from the same host or cluster to identify any signs of privilege escalation or lateral movement attempts.
- Assess the risk score and severity in the context of the environment to prioritize the investigation and response actions accordingly.


### False positive analysis

- Routine access by system processes or monitoring tools can trigger false positives. Identify these processes and create exceptions to prevent unnecessary alerts.
- Automated scripts or applications that regularly access service account secrets for legitimate purposes may be flagged. Review these scripts and whitelist them if they are verified as non-threatening.
- Development and testing environments often have processes accessing service account secrets as part of normal operations. Exclude these environments from the rule or adjust the rule's scope to focus on production environments.
- Frequent access by container orchestration tools or agents that manage Kubernetes clusters can be mistaken for unauthorized access. Ensure these tools are recognized and excluded from triggering alerts.
- Scheduled jobs or cron tasks that interact with service account secrets for maintenance or updates might be flagged. Validate these tasks and add them to an exception list if they are part of regular operations.


### Response and remediation

- Immediately isolate the affected pod or container to prevent further unauthorized access or lateral movement within the cluster.
- Revoke and rotate the compromised service account credentials to prevent further misuse. Ensure that new credentials are securely distributed and stored.
- Conduct a thorough review of access logs to identify any unauthorized actions or data access that occurred using the compromised credentials.
- Escalate the incident to the security operations team for further investigation and to assess the potential impact on the cluster and associated resources.
- Implement network segmentation and access controls to limit the exposure of sensitive secrets and reduce the risk of unauthorized access in the future.
- Enhance monitoring and alerting for unusual access patterns to Kubernetes service account secrets to detect similar threats promptly.
- Review and update Kubernetes security policies to enforce least privilege access and ensure that service accounts have only the necessary permissions for their intended functions.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and (
  process.command_line like (
    "*/run/secrets/kubernetes.io/serviceaccount*",
    "*/var/run/secrets/kubernetes.io/serviceaccount*",
    "*/secrets/kubernetes.io/serviceaccount*"
  ) or (
    process.working_directory like (
      "/run/secrets/kubernetes.io/serviceaccount",
      "/var/run/secrets/kubernetes.io/serviceaccount",
      "/secrets/kubernetes.io/serviceaccount"
    ) and
    process.args in ("ca.crt", "token")
  )
) and
not (
  process.command_line like "*/bin/test*" or
  process.args in (
    "/var/run/secrets/kubernetes.io/serviceaccount/namespace",
    "/run/secrets/kubernetes.io/serviceaccount/namespace",
    "/secrets/kubernetes.io/serviceaccount/namespace"
  ) or
  process.command_line == "/usr/bin/coreutils --coreutils-prog-shebang=cat /usr/bin/cat /var/run/secrets/kubernetes.io/serviceaccount/token" or
  process.parent.command_line == "runc init" or
  (process.parent.name == "px-oci-mon" and process.name == "rsync") or
  (
    process.parent.command_line == "sh /install-cni.sh" and
    process.working_directory like (
      "/opt/cni/bin", "/run/containerd/io.containerd.runtime.v2.task/k8s.io/*/opt/cni/bin"
    )
  ) or
  (process.working_directory like "/home/runner/_work/*" and process.parent.args like "/home/runner/_work/_temp/*.sh") or
  process.working_directory == "/opt/cni/bin"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Unsecured Credentials
- Id: T1552
- Reference URL: [[https://attack.mitre.org/techniques/T1552/](https://attack.mitre.org/techniques/T1552/)](https://attack.mitre.org/techniques/T1552/)
- Technique:
  - Name: Steal Application Access Token
- Id: T1528
- Reference URL: [[https://attack.mitre.org/techniques/T1528/](https://attack.mitre.org/techniques/T1528/)](https://attack.mitre.org/techniques/T1528/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Container and Resource Discovery
- Id: T1613
- Reference URL: [[https://attack.mitre.org/techniques/T1613/](https://attack.mitre.org/techniques/T1613/)](https://attack.mitre.org/techniques/T1613/)