﻿---
title: Linux init (PID 1) Secret Dump via GDB
description: This rule monitors for the potential memory dump of the init process (PID 1) through gdb. Attackers may leverage memory dumping techniques to attempt...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_gdb_init_process_hooking
products:
  - Elastic Security
---

# Linux init (PID 1) Secret Dump via GDB
This rule monitors for the potential memory dump of the init process (PID 1) through gdb. Attackers may leverage memory
dumping techniques to attempt secret extraction from privileged processes. Tools that display this behavior include
"truffleproc" and "bash-memory-dump". This behavior should not happen by default, and should be investigated thoroughly.
**Rule type**: eql
**Rule indices**:
- auditbeat-*
- endgame-*
- logs-crowdstrike.fdr*
- logs-endpoint.events.process*
- logs-sentinel_one_cloud_funnel.*
- logs-auditd_manager.auditd-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://github.com/controlplaneio/truffleproc](https://github.com/controlplaneio/truffleproc)](https://github.com/controlplaneio/truffleproc)
- [[https://github.com/hajzer/bash-memory-dump](https://github.com/hajzer/bash-memory-dump)](https://github.com/hajzer/bash-memory-dump)

**Tags**:
- Domain: Endpoint
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Data Source: Elastic Endgame
- Data Source: Crowdstrike
- Data Source: SentinelOne
- Data Source: Auditd Manager
- Resources: Investigation Guide

**Version**: 111
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.
  For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Linux init (PID 1) Secret Dump via GDB

In Linux, the init process (PID 1) is the first process started by the kernel and is responsible for initializing the system. Adversaries may exploit debugging tools like GDB to dump memory from this process, potentially extracting sensitive information. The detection rule identifies suspicious GDB executions targeting PID 1, flagging unauthorized memory access attempts for further investigation.

### Possible investigation steps

- Review the alert details to confirm the process name is "gdb" and the process arguments include "--pid" or "-p" with a target of PID "1".
- Check the user account associated with the gdb process execution to determine if it is authorized to perform debugging tasks on the system.
- Investigate the parent process of the gdb execution to understand how it was initiated and whether it was part of a legitimate workflow or script.
- Examine system logs around the time of the alert to identify any other suspicious activities or related events that might indicate a broader attack.
- Assess the system for any unauthorized changes or anomalies, such as new user accounts, modified configurations, or unexpected network connections.
- If possible, capture and analyze memory dumps or other forensic artifacts to identify any sensitive information that may have been accessed or exfiltrated.


### False positive analysis

- System administrators or developers may use GDB for legitimate debugging purposes on the init process. To handle this, create exceptions for known maintenance windows or specific user accounts that are authorized to perform such actions.
- Automated scripts or monitoring tools might inadvertently trigger this rule if they include GDB commands targeting PID 1 for health checks. Review and adjust these scripts to avoid unnecessary memory access or exclude them from the rule if they are verified as safe.
- Security tools or forensic analysis software might use GDB as part of their operations. Identify these tools and whitelist their processes to prevent false positives while ensuring they are from trusted sources.
- Training or testing environments may simulate attacks or debugging scenarios involving GDB and PID 1. Exclude these environments from the rule to avoid noise, ensuring they are isolated from production systems.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or data exfiltration.
- Terminate the suspicious gdb process targeting PID 1 to stop any ongoing memory dumping activity.
- Conduct a thorough review of system logs and process execution history to identify any additional unauthorized access attempts or related suspicious activities.
- Change all credentials and secrets that may have been exposed or accessed during the memory dump, focusing on those used by the init process and other privileged accounts.
- Implement stricter access controls and monitoring for debugging tools like gdb, ensuring only authorized personnel can execute such tools on critical systems.
- Escalate the incident to the security operations team for a comprehensive investigation and to determine if further forensic analysis is required.
- Update and enhance detection rules and monitoring systems to better identify and alert on similar unauthorized memory access attempts in the future.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action in ("exec", "exec_event", "start", "ProcessRollup2", "executed", "process_started") and
process.name == "gdb" and process.args in ("--pid", "-p") and process.args == "1"
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: OS Credential Dumping
- Id: T1003
- Reference URL: [[https://attack.mitre.org/techniques/T1003/](https://attack.mitre.org/techniques/T1003/)](https://attack.mitre.org/techniques/T1003/)
- Sub Technique:
  - Name: Proc Filesystem
- Id: T1003.007
- Reference URL: [[https://attack.mitre.org/techniques/T1003/007/](https://attack.mitre.org/techniques/T1003/007/)](https://attack.mitre.org/techniques/T1003/007/)