﻿---
title: AWS Credentials Searched For Inside A Container
description: This rule detects the use of system search utilities like grep and find to search for AWS credentials inside a container. Unauthorized access to these...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/linux/credential_access_aws_creds_search_inside_container
products:
  - Elastic Security
---

# AWS Credentials Searched For Inside A Container
This rule detects the use of system search utilities like grep and find to search for AWS credentials inside a
container. Unauthorized access to these sensitive files could lead to further compromise of the container environment or
facilitate a container breakout to the underlying cloud environment.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://sysdig.com/blog/threat-detection-aws-cloud-containers/](https://sysdig.com/blog/threat-detection-aws-cloud-containers/)](https://sysdig.com/blog/threat-detection-aws-cloud-containers/)

**Tags**:
- Domain: Container
- OS: Linux
- Use Case: Threat Detection
- Tactic: Credential Access
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

This rule requires data coming in from Elastic Defend.

### Elastic Defend Integration Setup

Elastic Defend is integrated into the Elastic Agent using Fleet. Upon configuration, the integration allows the Elastic Agent to monitor events on your host and send data to the Elastic Security app.

#### Prerequisite Requirements:

- Fleet is required for Elastic Defend.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).


#### The following steps should be executed in order to add the Elastic Defend integration on a Linux System:

- Go to the Kibana home page and click "Add integrations".
- In the query bar, search for "Elastic Defend" and select the integration to see more details about it.
- Click "Add Elastic Defend".
- Configure the integration name and optionally add a description.
- Select the type of environment you want to protect, either "Traditional Endpoints" or "Cloud Workloads".
- Select a configuration preset. Each preset comes with different default settings for Elastic Agent, you can further customize these later by configuring the Elastic Defend integration policy. [Helper guide](https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html).
- We suggest selecting "Complete EDR (Endpoint Detection and Response)" as a configuration setting, that provides "All events; all preventions"
- Enter a name for the agent policy in "New agent policy name". If other agent policies already exist, you can click the "Existing hosts" tab and select an existing policy instead.

For more details on Elastic Agent configuration settings, refer to the [helper guide](https://www.elastic.co/guide/en/fleet/8.10/agent-policy.html).
- Click "Save and Continue".
- To complete the integration, select "Add Elastic Agent to your hosts" and continue to the next section to install the Elastic Agent on your hosts.
  For more details on Elastic Defend refer to the [helper guide](https://www.elastic.co/guide/en/security/current/install-endpoint.html).


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating AWS Credentials Searched For Inside A Container

Containers often house applications that interact with AWS services, necessitating the storage of AWS credentials. Adversaries may exploit this by using search utilities to locate these credentials, potentially leading to unauthorized access. The detection rule identifies suspicious use of search tools within containers, flagging attempts to locate AWS credentials by monitoring specific process names and arguments, thus helping to prevent credential theft and subsequent attacks.

### Possible investigation steps

- Review the process details to identify the specific search utility used (e.g., grep, find) and the arguments passed, focusing on those related to AWS credentials such as aws_access_key_id or aws_secret_access_key.
- Check the user context under which the suspicious process was executed to assess whether it aligns with expected behavior for that user or role within the container.
- Investigate the source of the container image to ensure it is from a trusted repository and has not been tampered with, which could indicate a supply chain compromise.
- Analyze recent activity logs for the container to identify any other suspicious behavior or anomalies that might correlate with the search for AWS credentials, such as unexpected network connections or file modifications.
- Review access logs for AWS services to detect any unauthorized or unusual access patterns that might suggest the use of compromised credentials.


### False positive analysis

- Routine maintenance scripts or automated processes may use search utilities to verify the presence of AWS credentials for legitimate configuration checks. To handle this, identify and whitelist these specific scripts or processes by their unique identifiers or execution paths.
- Developers or system administrators might manually search for AWS credentials during debugging or configuration tasks. Implement a policy to log and review these activities, and consider excluding known user accounts or roles from triggering alerts during specific time windows or in designated environments.
- Security audits or compliance checks often involve searching for sensitive information, including AWS credentials, to ensure proper security measures are in place. Coordinate with audit teams to schedule these activities and temporarily suppress alerts during these periods, or exclude specific audit tools from detection.
- Continuous integration and deployment (CI/CD) pipelines might include steps that search for AWS credentials to validate environment configurations. Identify these pipelines and exclude their associated processes or container environments from triggering alerts, ensuring that only authorized CI/CD tools are used.


### Response and remediation

- Immediately isolate the affected container to prevent further unauthorized access or data exfiltration. This can be done by stopping the container or disconnecting it from the network.
- Revoke any AWS credentials that were potentially exposed or accessed. This includes rotating keys and updating any services or applications that rely on these credentials.
- Conduct a thorough review of the container's file system to identify any unauthorized changes or additional malicious files that may have been introduced.
- Implement stricter access controls and monitoring on AWS credentials within containers, ensuring they are stored securely and accessed only by authorized processes.
- Escalate the incident to the cloud security team to assess the potential impact on the broader cloud environment and determine if further investigation or response is needed.
- Enhance logging and monitoring for similar activities across other containers and cloud environments to detect and respond to future attempts promptly.
- Review and update container security policies to include best practices for credential management and access control, reducing the risk of similar incidents.


## Rule Query

```eql
process where host.os.type == "linux" and event.type == "start" and event.action == "exec" and
process.entry_leader.entry_meta.type == "container" and
process.name in ("grep", "egrep", "fgrep", "find", "locate", "mlocate", "cat", "sed", "awk") and
process.command_line like~ (
  "*aws_access_key_id*", "*aws_secret_access_key*", "*aws_session_token*", "*accesskeyid*", "*secretaccesskey*",
  "*access_key*", "*.aws/credentials*"
)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Unsecured Credentials
- Id: T1552
- Reference URL: [[https://attack.mitre.org/techniques/T1552/](https://attack.mitre.org/techniques/T1552/)](https://attack.mitre.org/techniques/T1552/)
- Sub Technique:
  - Name: Credentials In Files
- Id: T1552.001
- Reference URL: [[https://attack.mitre.org/techniques/T1552/001/](https://attack.mitre.org/techniques/T1552/001/)](https://attack.mitre.org/techniques/T1552/001/)