﻿---
title: User Detected with Suspicious Windows Process(es)
description: A machine learning job combination has identified a user with one or more suspicious Windows processes that exhibit unusually high malicious probability...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_suspicious_windows_process_cluster_from_user
products:
  - Elastic Security
---

# User Detected with Suspicious Windows Process(es)
A machine learning job combination has identified a user with one or more suspicious Windows processes that exhibit
unusually high malicious probability scores. These process(es) have been classified as malicious in several ways. The
process(es) were predicted to be malicious by the ProblemChild supervised ML model. If the anomaly contains a cluster of
suspicious processes, each process has the same user name, and the aggregate score of the event cluster was calculated
to be unusually high by an unsupervised ML model. Such a cluster often contains suspicious or malicious activity,
possibly involving LOLbins, that may be resistant to detection using conventional search rules.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-45m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/problemchild](https://docs.elastic.co/en/integrations/problemchild)](https://docs.elastic.co/en/integrations/problemchild)
- [[https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration)](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Living off the Land Attack Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 110
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Living off the Land (LotL) Attack Detection integration assets to be installed, as well as Windows process events collected by integrations such as Elastic Defend or Winlogbeat.

### LotL Attack Detection Setup

The LotL Attack Detection integration detects living-off-the-land activity in Windows process events.

#### Prerequisite Requirements:

- Fleet is required for LotL Attack Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- Windows process events collected by the [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint) integration or Winlogbeat([https://www.elastic.co/guide/en/beats/winlogbeat/current/_winlogbeat_overview.html](https://www.elastic.co/guide/en/beats/winlogbeat/current/_winlogbeat_overview.html)).
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To set up and run Winlogbeat, follow [this](https://www.elastic.co/guide/en/beats/winlogbeat/current/winlogbeat-installation-configuration.html) guide.


#### The following steps should be executed to install assets associated with the LotL Attack Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Living off the Land Attack Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Add preconfigured anomaly detection jobs**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating User Detected with Suspicious Windows Process(es)

The detection leverages machine learning to identify clusters of Windows processes with high malicious probability, often linked to tactics like masquerading. Adversaries exploit legitimate tools (LOLBins) to evade detection. This rule uses both supervised and unsupervised ML models to flag unusual process clusters, focusing on user-associated anomalies to uncover potential threats.

### Possible investigation steps

- Review the list of processes flagged by the alert to identify any known legitimate applications or tools that might have been misclassified.
- Investigate the user account associated with the suspicious process cluster to determine if there is any history of unusual activity or if the account has been compromised.
- Examine the parent-child relationship of the processes to understand the execution chain and identify any potential masquerading attempts or use of LOLBins.
- Check for any recent changes or updates to the system that might explain the unusual process behavior, such as software installations or updates.
- Correlate the detected processes with any known indicators of compromise (IOCs) or threat intelligence feeds to assess if they are linked to known malicious activity.
- Analyze the network activity associated with the processes to identify any suspicious outbound connections or data exfiltration attempts.


### False positive analysis

- Legitimate administrative tools like PowerShell or Windows Management Instrumentation (WMI) may trigger false positives due to their frequent use in system management. Users can create exceptions for these tools when used by trusted administrators.
- Software updates or installations often involve processes that mimic suspicious behavior. Exclude these processes by identifying and whitelisting update-related activities from known software vendors.
- Automated scripts or scheduled tasks that perform routine maintenance can be misclassified as malicious. Review and whitelist these tasks if they are part of regular system operations.
- Development environments may spawn multiple processes that resemble malicious clusters. Developers should document and exclude these processes when they are part of legitimate development activities.
- Security software or monitoring tools might generate process clusters that appear suspicious. Ensure these tools are recognized and excluded from analysis to prevent false alerts.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of potential malicious activity.
- Terminate the suspicious processes identified by the alert to halt any ongoing malicious actions.
- Conduct a thorough review of the affected user's account for any unauthorized access or changes, and reset credentials if necessary.
- Analyze the use of any identified LOLBins to determine if they were used maliciously and restrict their execution through application whitelisting or policy adjustments.
- Collect and preserve relevant logs and forensic data from the affected system for further analysis and to aid in understanding the scope of the incident.
- Escalate the incident to the security operations center (SOC) or incident response team for a deeper investigation and to determine if additional systems are compromised.
- Implement enhanced monitoring and detection rules to identify similar patterns of behavior in the future, focusing on the specific tactics and techniques used in this incident.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)