﻿---
title: Parent Process Detected with Suspicious Windows Process(es)
description: A machine learning job combination has identified a parent process with one or more suspicious Windows processes that exhibit unusually high malicious...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_suspicious_windows_process_cluster_from_parent_process
products:
  - Elastic Security
---

# Parent Process Detected with Suspicious Windows Process(es)
A machine learning job combination has identified a parent process with one or more suspicious Windows processes that
exhibit unusually high malicious probability scores. These process(es) have been classified as malicious in several
ways. The process(es) were predicted to be malicious by the ProblemChild supervised ML model. If the anomaly contains a
cluster of suspicious processes, each process has the same parent process name, and the aggregate score of the event
cluster was calculated to be unusually high by an unsupervised ML model. Such a cluster often contains suspicious or
malicious activity, possibly involving LOLbins, that may be resistant to detection using conventional search rules.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-45m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/problemchild](https://docs.elastic.co/en/integrations/problemchild)](https://docs.elastic.co/en/integrations/problemchild)
- [[https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration)](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration)

**Tags**:
- Domain: Endpoint
- OS: Windows
- Use Case: Living off the Land Attack Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 110
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Living off the Land (LotL) Attack Detection integration assets to be installed, as well as Windows process events collected by integrations such as Elastic Defend or Winlogbeat.

### LotL Attack Detection Setup

The LotL Attack Detection integration detects living-off-the-land activity in Windows process events.

#### Prerequisite Requirements:

- Fleet is required for LotL Attack Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- Windows process events collected by the [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint) integration or Winlogbeat([https://www.elastic.co/guide/en/beats/winlogbeat/current/_winlogbeat_overview.html](https://www.elastic.co/guide/en/beats/winlogbeat/current/_winlogbeat_overview.html)).
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To set up and run Winlogbeat, follow [this](https://www.elastic.co/guide/en/beats/winlogbeat/current/winlogbeat-installation-configuration.html) guide.


#### The following steps should be executed to install assets associated with the LotL Attack Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Living off the Land Attack Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Add preconfigured anomaly detection jobs**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Parent Process Detected with Suspicious Windows Process(es)

In Windows environments, processes are often spawned by parent processes, forming a hierarchy. Adversaries exploit this by using legitimate processes to launch malicious ones, often leveraging Living off the Land Binaries (LOLBins) to evade detection. The detection rule employs machine learning to identify clusters of processes with high malicious probability, focusing on those sharing a common parent process. This approach helps uncover stealthy attacks that traditional methods might miss, enhancing defense against tactics like masquerading.

### Possible investigation steps

- Review the parent process name associated with the suspicious process cluster to identify if it is a known legitimate process or a potential masquerading attempt.
- Examine the command line arguments and execution context of the suspicious processes to identify any use of LOLBins or unusual patterns that could indicate malicious activity.
- Check the process creation timestamps and correlate them with any known events or user activities to determine if the process execution aligns with expected behavior.
- Investigate the network activity of the suspicious processes to identify any unusual outbound connections or data exfiltration attempts.
- Analyze the user account context under which the suspicious processes were executed to determine if there is any indication of compromised credentials or privilege escalation.
- Cross-reference the detected processes with threat intelligence sources to identify any known indicators of compromise or related threat actor activity.


### False positive analysis

- Legitimate administrative tools may trigger false positives if they frequently spawn processes that resemble malicious activity. Users can create exceptions for known safe tools by whitelisting their parent process names.
- Software updates or installations often generate clusters of processes that might be flagged as suspicious. Users should monitor these activities and exclude them if they are verified as legitimate.
- Automated scripts or batch jobs that run regularly and spawn multiple processes can be mistaken for malicious clusters. Identifying these scripts and excluding their parent processes can reduce false positives.
- Security software or monitoring tools that perform regular scans or updates might mimic malicious behavior. Users should ensure these tools are recognized and excluded from the rule's scope.
- Custom business applications that are not widely recognized might be flagged. Users should document and exclude these applications if they are confirmed to be safe and necessary for operations.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of the potential threat and to contain any ongoing malicious activity.
- Terminate the suspicious processes identified by the alert to stop any malicious actions they may be performing.
- Conduct a thorough review of the parent process and its associated binaries to ensure they have not been tampered with or replaced by malicious versions.
- Restore any affected files or system components from a known good backup to ensure system integrity and functionality.
- Update and patch the system to close any vulnerabilities that may have been exploited by the adversary, focusing on those related to LOLBins and masquerading techniques.
- Monitor the system and network for any signs of re-infection or related suspicious activity, using enhanced logging and alerting mechanisms.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)