﻿---
title: Machine Learning Detected a Suspicious Windows Event with a Low Malicious Probability Score
description: A supervised machine learning model (ProblemChild) has identified a suspicious Windows process event with low probability of it being malicious activity...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_suspicious_windows_event_low_probability
products:
  - Elastic Security
---

# Machine Learning Detected a Suspicious Windows Event with a Low Malicious Probability Score
A supervised machine learning model (ProblemChild) has identified a suspicious Windows process event with low
probability of it being malicious activity. Alternatively, the model's blocklist identified the event as being
malicious.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 
**Searches indices from**: `now-10m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/problemchild](https://docs.elastic.co/en/integrations/problemchild)](https://docs.elastic.co/en/integrations/problemchild)
- [[https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration)](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration)

**Tags**:
- OS: Windows
- Data Source: Elastic Endgame
- Use Case: Living off the Land Attack Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 13
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Living off the Land (LotL) Attack Detection integration assets to be installed, as well as Windows process events collected by integrations such as Elastic Defend or Winlogbeat.

### LotL Attack Detection Setup

The LotL Attack Detection integration detects living-off-the-land activity in Windows process events.

#### Prerequisite Requirements:

- Fleet is required for LotL Attack Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- Windows process events collected by the [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint) integration or Winlogbeat([https://www.elastic.co/guide/en/beats/winlogbeat/current/_winlogbeat_overview.html](https://www.elastic.co/guide/en/beats/winlogbeat/current/_winlogbeat_overview.html)).
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To set up and run Winlogbeat, follow [this](https://www.elastic.co/guide/en/beats/winlogbeat/current/winlogbeat-installation-configuration.html) guide.


#### The following steps should be executed to install assets associated with the LotL Attack Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Living off the Land Attack Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Configure the ingest pipeline**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Machine Learning Detected a Suspicious Windows Event with a Low Malicious Probability Score

The detection leverages a machine learning model to identify potentially suspicious Windows processes with a low likelihood of being malicious, focusing on defense evasion tactics like masquerading. Adversaries may exploit legitimate processes to bypass security measures. This rule flags such events, excluding known benign patterns, to highlight potential threats for further analysis.

### Possible investigation steps

- Review the process details where the problemchild.prediction is 1 and the prediction_probability is less than or equal to 0.98 to understand why the process was flagged as suspicious.
- Check if the process is listed in the blocklist_label as 1, indicating it has been identified as malicious by the model's blocklist.
- Investigate the command-line arguments of the process to identify any unusual or unexpected patterns, excluding known benign patterns such as those involving "C:\WINDOWS\temp\nessus_*.txt" or "C:\WINDOWS\temp\nessus_*.tmp".
- Correlate the flagged process with other system events or logs to determine if it is part of a larger pattern of suspicious activity, focusing on defense evasion tactics like masquerading.
- Assess the parent process and any child processes spawned by the suspicious process to identify potential lateral movement or further malicious activity.
- Consult threat intelligence sources to see if the process or its associated indicators have been reported in recent threat reports or advisories.


### False positive analysis

- Nessus scan files in the Windows temp directory may trigger false positives. Exclude paths like C:\WINDOWS\temp\nessus_*.txt and C:\WINDOWS\temp\nessus_*.tmp to prevent these benign events from being flagged.
- Legitimate software updates or installations might mimic suspicious behavior. Monitor and document regular update schedules to differentiate between expected and unexpected activities.
- System administration scripts that automate tasks can appear suspicious. Identify and whitelist these scripts if they are part of routine operations to avoid unnecessary alerts.
- Custom in-house applications may not be recognized by the model. Work with IT to catalog these applications and create exceptions where necessary to reduce false positives.
- Regularly review and update the blocklist and exception rules to ensure they reflect the current environment and known benign activities.


### Response and remediation

- Isolate the affected system from the network to prevent potential lateral movement by the adversary exploiting the masquerading technique.
- Terminate the suspicious process identified by the machine learning model to halt any ongoing malicious activity.
- Conduct a thorough review of the process's parent and child processes to identify any additional suspicious activities or related processes that may require termination.
- Restore the system from a known good backup if any malicious activity is confirmed, ensuring that the backup is free from compromise.
- Update and patch the system to the latest security standards to close any vulnerabilities that may have been exploited.
- Implement enhanced monitoring for similar masquerading attempts by adjusting alert thresholds or adding specific indicators of compromise (IOCs) related to the detected event.
- Escalate the incident to the security operations center (SOC) or relevant security team for further analysis and to determine if additional systems are affected.


## Rule Query

```eql
process where ((problemchild.prediction == 1 and problemchild.prediction_probability <= 0.98) or
blocklist_label == 1) and not process.args : ("*C:\\WINDOWS\\temp\\nessus_*.txt*", "*C:\\WINDOWS\\temp\\nessus_*.tmp*") and
process.parent.executable != null and not user.id in ("S-1-5-18", "S-1-5-19", "S-1-5-20") and
not process.parent.name : ("cmd.exe", "powershell.exe") and
not (process.name == "net1.exe" and process.parent.name == "net.exe") and
not (process.parent.executable : "C:\\Windows\\System32\\svchost.exe" and
     process.name : ("UCPDMgr.exe", "sdbinst.exe", "gpupdate.exe", "rundll32.exe", "taskhostw.exe", "taskeng.exe")) and
not (process.name: ("powershell.exe", "cmd.exe", "cscript.exe") and
     process.parent.executable : ("C:\\Program Files\\*.exe",
                                  "C:\\Program Files (x86)\\*.exe",
                                  "C:\\Users\\*\\Documents\\scripts\\nssm-2.24\\win64\\nssm.exe",
                                  "C:\\Windows\\System32\\cmd.exe",
                                  "C:\\Windows\\SysWOW64\\cmd.exe",
                                  "C:\\Windows\\CCM\\CcmExec.exe",
                                  "C:\\Windows\\System32\\svchost.exe",
                                  "C:\\Windows\\System32\\gpscript.exe",
                                  "C:\\Windows\\System32\\wbem\\WmiPrvSE.exe",
                                  "C:\\appian\\java\\bin\\java.exe")) and
not (process.executable : "C:\\Windows\\System32\\cscript.exe" and process.parent.name : ("node.exe", "MicroStrategy Services.exe")) and
not (process.name : "MpCmdRun.exe" and process.parent.name : ("MsMpEng.exe", "MpCmdRun.exe", "svchost.exe")) and
not process.executable : ("C:\\Program Files\\*.exe", "C:\\Program Files (x86)\\*.exe")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Masquerade Task or Service
- Id: T1036.004
- Reference URL: [[https://attack.mitre.org/techniques/T1036/004/](https://attack.mitre.org/techniques/T1036/004/)](https://attack.mitre.org/techniques/T1036/004/)