﻿---
title: Machine Learning Detected a Suspicious Windows Event with a High Malicious Probability Score
description: A supervised machine learning model (ProblemChild) has identified a suspicious Windows process event with high probability of it being malicious activity...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/problemchild/defense_evasion_ml_suspicious_windows_event_high_probability
products:
  - Elastic Security
---

# Machine Learning Detected a Suspicious Windows Event with a High Malicious Probability Score
A supervised machine learning model (ProblemChild) has identified a suspicious Windows process event with high
probability of it being malicious activity. Alternatively, the model's blocklist identified the event as being
malicious.
**Rule type**: eql
**Rule indices**:
- logs-endpoint.events.process-*

**Rule Severity**: high
**Risk Score**: 73
**Runs every**: 
**Searches indices from**: `now-10m`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/problemchild](https://docs.elastic.co/en/integrations/problemchild)](https://docs.elastic.co/en/integrations/problemchild)
- [[https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration)](https://www.elastic.co/security-labs/detecting-living-off-the-land-attacks-with-new-elastic-integration)

**Tags**:
- OS: Windows
- Data Source: Elastic Endgame
- Use Case: Living off the Land Attack Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Defense Evasion
- Data Source: Elastic Defend
- Resources: Investigation Guide

**Version**: 116
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Living off the Land (LotL) Attack Detection integration assets to be installed, as well as Windows process events collected by integrations such as Elastic Defend or Winlogbeat.

### LotL Attack Detection Setup

The LotL Attack Detection integration detects living-off-the-land activity in Windows process events.

#### Prerequisite Requirements:

- Fleet is required for LotL Attack Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- Windows process events collected by the [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint) integration or Winlogbeat([https://www.elastic.co/guide/en/beats/winlogbeat/current/_winlogbeat_overview.html](https://www.elastic.co/guide/en/beats/winlogbeat/current/_winlogbeat_overview.html)).
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To set up and run Winlogbeat, follow [this](https://www.elastic.co/guide/en/beats/winlogbeat/current/winlogbeat-installation-configuration.html) guide.


#### The following steps should be executed to install assets associated with the LotL Attack Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Living off the Land Attack Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Configure the ingest pipeline**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Machine Learning Detected a Suspicious Windows Event with a High Malicious Probability Score

The detection leverages a machine learning model, ProblemChild, to identify potentially malicious Windows processes by analyzing patterns and assigning a high probability score to suspicious activities. Adversaries may exploit legitimate processes to evade detection, often using techniques like masquerading. This rule flags high-risk events by focusing on processes with a high malicious probability score or those identified by a blocklist, excluding known benign activities.

### Possible investigation steps

- Review the process details flagged by the ProblemChild model, focusing on those with a prediction probability greater than 0.98 or identified by the blocklist.
- Examine the command-line arguments of the suspicious process to identify any unusual or unexpected patterns, excluding those matching known benign patterns like "*C:\WINDOWS\temp\nessus_*.txt*" or "*C:\WINDOWS\temp\nessus_*.tmp*".
- Check the parent process of the flagged event to determine if it is a legitimate process or if it has been potentially compromised.
- Investigate the user account associated with the process to assess if it has been involved in any other suspicious activities or if it has elevated privileges that could be exploited.
- Correlate the event with other security alerts or logs to identify any related activities or patterns that could indicate a broader attack campaign.
- Consult threat intelligence sources to determine if the process or its associated indicators are linked to known malicious activities or threat actors.


### False positive analysis

- Nessus scan files in the Windows temp directory may trigger false positives due to their temporary nature and frequent legitimate use. Users can mitigate this by adding exceptions for file paths like C:\WINDOWS\temp\nessus_*.txt and C:\WINDOWS\temp\nessus_*.tmp.
- Legitimate software updates or installations might be flagged if they mimic known malicious patterns. Users should review the process details and whitelist trusted software update processes.
- System administration tools that perform actions similar to those used in attacks could be misidentified. Users should verify the legitimacy of these tools and exclude them from the rule if they are part of regular administrative tasks.
- Custom scripts or automation tools that are not widely recognized might be flagged. Users should ensure these scripts are secure and add them to an allowlist if they are part of routine operations.
- Frequent false positives from specific processes can be managed by adjusting the threshold of the machine learning model or refining the blocklist to better distinguish between benign and malicious activities.


### Response and remediation

- Isolate the affected system from the network to prevent further spread of potential malicious activity.
- Terminate the suspicious process identified by the ProblemChild model to halt any ongoing malicious actions.
- Conduct a thorough scan of the affected system using updated antivirus and anti-malware tools to identify and remove any additional threats.
- Review and analyze the process execution history and associated files to understand the scope of the compromise and identify any persistence mechanisms.
- Restore any altered or deleted files from backups, ensuring that the backup is clean and free from malware.
- Escalate the incident to the security operations center (SOC) or incident response team for further investigation and to determine if additional systems are affected.
- Implement enhanced monitoring and logging for similar processes and activities to detect and respond to future attempts at masquerading or defense evasion.


## Rule Query

```eql
process where ((problemchild.prediction == 1 and problemchild.prediction_probability > 0.98) or
blocklist_label == 1) and not process.args : ("*C:\\WINDOWS\\temp\\nessus_*.txt*", "*C:\\WINDOWS\\temp\\nessus_*.tmp*") and
process.parent.executable != null and not user.id in ("S-1-5-18", "S-1-5-19", "S-1-5-20") and
not process.parent.name : ("cmd.exe", "powershell.exe", "Perplexity.exe", "vmtoolsd.exe", "Code.exe", "explorer.exe", "git.exe") and
not (process.name : "msedgewebview2.exe" and process.parent.name : "msedgewebview2.exe") and
not (process.name : "opera.exe" and process.parent.name : "opera.exe") and
not (process.parent.executable : "C:\\Windows\\System32\\svchost.exe" and
     process.name : ("UCPDMgr.exe", "sdbinst.exe", "gpupdate.exe", "rundll32.exe", "taskhostw.exe", "taskeng.exe", "rdpclip.exe", "firefox.exe", "w3wp.exe")) and
not process.executable : ("C:\\Program Files\\*.exe", "C:\\Program Files (x86)\\*.exe") and
not (process.name : "MpCmdRun.exe" and process.parent.name : ("MsMpEng.exe", "MpCmdRun.exe", "svchost.exe")) and
not (process.name : "slack.exe" and process.parent.name : "slack.exe") and
not (process.name : "reg.exe" and process.parent.name : "pycharm64.exe") and
not (process.name : "reg.exe" and process.parent.name : "rider64.exe") and
not (process.name : "LogiLuUpdater.exe" and process.parent.name : "LogiOptionsMgr.exe") and
not (process.name : "chrome.exe" and process.parent.name : "node.exe" and process.command_line  : "*playwright*") and
not (process.name : "powershell.exe" and process.command_line : "*\\Zabbix_Scripts\\*.ps1*") and
not (process.parent.name : "opera.exe" and process.command_line: "*--type=renderer*")
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Masquerading
- Id: T1036
- Reference URL: [[https://attack.mitre.org/techniques/T1036/](https://attack.mitre.org/techniques/T1036/)](https://attack.mitre.org/techniques/T1036/)
- Sub Technique:
  - Name: Masquerade Task or Service
- Id: T1036.004
- Reference URL: [[https://attack.mitre.org/techniques/T1036/004/](https://attack.mitre.org/techniques/T1036/004/)](https://attack.mitre.org/techniques/T1036/004/)