﻿---
title: Unusual Group Name Accessed by a User
description: A machine learning job has detected a user accessing an uncommon group name for privileged operations, indicating potential privileged access activity...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_rare_group_name_by_user
products:
  - Elastic Security
---

# Unusual Group Name Accessed by a User
A machine learning job has detected a user accessing an uncommon group name for privileged operations, indicating
potential privileged access activity. This indicates that a user has accessed a group name that is unusual for their
typical operations, particularly for actions requiring elevated privileges. This could point to an attempt to manipulate
group memberships or escalate privileges on a system.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-1h`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/pad](https://docs.elastic.co/en/integrations/pad)](https://docs.elastic.co/en/integrations/pad)

**Tags**:
- Use Case: Privileged Access Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Privileged Access Detection integration assets to be installed, as well as Windows logs collected by integrations such as Elastic Defend and Windows.

### Privileged Access Detection Setup

The Privileged Access Detection integration detects privileged access activity by identifying abnormalities in Windows, Linux and Okta events. Anomalies are detected using Elastic's Anomaly Detection feature.

#### Prerequisite Requirements:

- Fleet is required for Privileged Access Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- Windows events collected by the [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint) and [Windows](https://docs.elastic.co/en/integrations/windows) integration.
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To add the Windows integration to an Elastic Agent policy, refer to [this](https://www.elastic.co/guide/en/fleet/current/add-integration-to-policy.html) guide.


#### The following steps should be executed to install assets associated with the Privileged Access Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Privileged Access Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Add preconfigured anomaly detection jobs**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Unusual Group Name Accessed by a User

In IT environments, group names often define access levels and permissions. Adversaries may exploit this by accessing or altering uncommon group names to escalate privileges. The detection rule leverages machine learning to identify deviations from a user's typical access patterns, flagging unusual group name access as a potential indicator of privilege escalation attempts. This proactive approach helps in early detection of unauthorized access activities.

### Possible investigation steps

- Review the alert details to identify the specific user and the unusual group name accessed. Note the timestamp of the access for further context.
- Check the user's historical access patterns to determine if this group name access is indeed anomalous compared to their typical behavior.
- Investigate the permissions and roles associated with the unusual group name to assess the potential impact of the access.
- Examine recent changes to the user's account, such as password resets or modifications to account settings, which might indicate account compromise.
- Correlate this event with other security alerts or logs, such as login attempts from unusual locations or times, to identify potential indicators of compromise.
- Contact the user or their manager to verify if the access was legitimate and authorized, documenting any explanations provided.
- If unauthorized access is suspected, initiate a security incident response process to mitigate any potential threats and prevent further unauthorized access.


### False positive analysis

- Routine administrative tasks may trigger alerts if administrators access uncommon group names for legitimate system maintenance. To manage this, create exceptions for known administrative accounts performing regular tasks.
- Automated scripts or services that require access to various group names for operational purposes might be flagged. Identify these scripts and whitelist their activities to prevent false positives.
- Temporary project groups or newly created groups for specific tasks can appear unusual. Document and monitor these groups, and update the machine learning model to recognize them as non-threatening.
- Cross-departmental collaborations may involve users accessing group names outside their usual scope. Establish a process to review and approve such access, and adjust the detection rule to accommodate these scenarios.
- Changes in user roles or responsibilities can lead to access pattern deviations. Ensure that role changes are communicated to the security team to update access baselines accordingly.


### Response and remediation

- Immediately isolate the affected user account to prevent further unauthorized access or privilege escalation. This can be done by disabling the account or changing its password.
- Review and audit the group membership changes associated with the unusual group name to identify any unauthorized modifications. Revert any unauthorized changes to restore the original group settings.
- Conduct a thorough investigation of the user's recent activities to identify any other suspicious actions or access patterns that may indicate further compromise.
- Notify the security team and relevant stakeholders about the potential privilege escalation attempt to ensure awareness and coordinated response efforts.
- Implement additional monitoring on the affected user account and the unusual group name to detect any further unauthorized access attempts.
- Review and update access control policies to ensure that only authorized users have access to sensitive group names and privileged operations.
- Consider implementing additional security measures, such as multi-factor authentication, for accessing sensitive group names to prevent unauthorized access in the future.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Discovery
- Id: TA0007
- Reference URL: [[https://attack.mitre.org/tactics/TA0007/](https://attack.mitre.org/tactics/TA0007/)](https://attack.mitre.org/tactics/TA0007/)
- Technique:
  - Name: Permission Groups Discovery
- Id: T1069
- Reference URL: [[https://attack.mitre.org/techniques/T1069/](https://attack.mitre.org/techniques/T1069/)](https://attack.mitre.org/techniques/T1069/)