﻿---
title: Spike in Special Privilege Use Events
description: A machine learning job has detected an unusual increase in special privilege usage events, such as privileged operations and service calls, for a user,...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_high_count_special_privilege_use_events
products:
  - Elastic Security
---

# Spike in Special Privilege Use Events
A machine learning job has detected an unusual increase in special privilege usage events, such as privileged operations
and service calls, for a user, suggesting potential unauthorized privileged access. A sudden spike in these events may
indicate an attempt to escalate privileges, execute unauthorized tasks, or maintain persistence within a system.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-3h`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/pad](https://docs.elastic.co/en/integrations/pad)](https://docs.elastic.co/en/integrations/pad)

**Tags**:
- Use Case: Privileged Access Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Privileged Access Detection integration assets to be installed, as well as Windows logs collected by integrations such as Elastic Defend and Windows.

### Privileged Access Detection Setup

The Privileged Access Detection integration detects privileged access activity by identifying abnormalities in Windows, Linux and Okta events. Anomalies are detected using Elastic's Anomaly Detection feature.

#### Prerequisite Requirements:

- Fleet is required for Privileged Access Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- Windows events collected by the [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint) and [Windows](https://docs.elastic.co/en/integrations/windows) integration.
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To add the Windows integration to an Elastic Agent policy, refer to [this](https://www.elastic.co/guide/en/fleet/current/add-integration-to-policy.html) guide.


#### The following steps should be executed to install assets associated with the Privileged Access Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Privileged Access Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Add preconfigured anomaly detection jobs**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Spike in Special Privilege Use Events

Machine learning models monitor special privilege use, identifying anomalies that suggest unauthorized access. Adversaries exploit these privileges to escalate access, execute unauthorized actions, or maintain system persistence. The detection rule leverages ML to spot unusual spikes in privileged operations, flagging potential misuse for further investigation.

### Possible investigation steps

- Review the user account associated with the spike in special privilege use events to determine if the activity aligns with their normal behavior or job role.
- Examine the specific privileged operations and service calls that were flagged to identify any unusual or unauthorized actions.
- Check for any recent changes in user permissions or group memberships that could explain the increase in privilege use.
- Investigate any corresponding logs or alerts around the same timeframe to identify potential indicators of compromise or related suspicious activities.
- Assess the system or application where the privilege escalation occurred for any signs of exploitation or unauthorized access attempts.
- Correlate the detected spike with known threat intelligence or recent security advisories to determine if it matches any known attack patterns or vulnerabilities.


### False positive analysis

- Routine administrative tasks by IT personnel can trigger false positives. Regularly review and whitelist known administrative accounts to prevent unnecessary alerts.
- Scheduled maintenance activities often involve elevated privileges. Document and exclude these activities from monitoring during known maintenance windows.
- Automated scripts or services that require elevated privileges may cause spikes. Identify and exclude these scripts or services from the rule to reduce false positives.
- Software updates or installations can lead to temporary spikes in privilege use. Coordinate with IT to recognize these events and adjust monitoring rules accordingly.
- Frequent legitimate use of privileged operations by certain users or roles should be analyzed. Establish a baseline for these users and adjust the detection threshold to accommodate their normal activity levels.


### Response and remediation

- Immediately isolate the affected user account to prevent further unauthorized privileged operations. Disable the account or change its credentials to stop potential misuse.
- Conduct a thorough review of recent privileged operations and service calls associated with the user account to identify any unauthorized actions or changes made during the spike.
- Revoke any unnecessary privileges or access rights from the affected user account to minimize the risk of future exploitation.
- Implement additional monitoring on the affected system and user account to detect any further suspicious activities or attempts to regain unauthorized access.
- Escalate the incident to the security operations team for a deeper investigation into potential privilege escalation techniques used, referencing MITRE ATT&CK technique T1068.
- Review and update access control policies and privilege management practices to ensure they align with the principle of least privilege, reducing the risk of similar incidents.
- Conduct a post-incident analysis to identify any gaps in detection or response and enhance the machine learning model's ability to detect similar threats in the future.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)