﻿---
title: Spike in Special Logon Events
description: A machine learning job has detected a surge in special logon events for a user, indicating potential privileged access activity. A sudden spike in these...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_windows_high_count_special_logon_events
products:
  - Elastic Security
---

# Spike in Special Logon Events
A machine learning job has detected a surge in special logon events for a user, indicating potential privileged access
activity. A sudden spike in these events could suggest an attacker or malicious insider gaining elevated access,
possibly for lateral movement or privilege escalation.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-3h`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/pad](https://docs.elastic.co/en/integrations/pad)](https://docs.elastic.co/en/integrations/pad)

**Tags**:
- Use Case: Privileged Access Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Privileged Access Detection integration assets to be installed, as well as Windows logs collected by integrations such as Elastic Defend and Windows.

### Privileged Access Detection Setup

The Privileged Access Detection integration detects privileged access activity by identifying abnormalities in Windows, Linux and Okta events. Anomalies are detected using Elastic's Anomaly Detection feature.

#### Prerequisite Requirements:

- Fleet is required for Privileged Access Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- Windows events collected by the [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint) and [Windows](https://docs.elastic.co/en/integrations/windows) integration.
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To add the Windows integration to an Elastic Agent policy, refer to [this](https://www.elastic.co/guide/en/fleet/current/add-integration-to-policy.html) guide.


#### The following steps should be executed to install assets associated with the Privileged Access Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Privileged Access Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Add preconfigured anomaly detection jobs**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Spike in Special Logon Events

Special logon events are crucial for tracking privileged access, often indicating administrative actions. Adversaries exploit these by gaining elevated access to perform unauthorized activities, such as lateral movement or privilege escalation. The detection rule leverages machine learning to identify unusual spikes in these events, signaling potential misuse and enabling timely investigation of suspicious privileged access activities.

### Possible investigation steps

- Review the user account associated with the spike in special logon events to determine if the account is expected to have privileged access.
- Check the time and frequency of the special logon events to identify any unusual patterns or times that deviate from the user's normal behavior.
- Investigate the source IP addresses and devices from which the special logon events originated to verify if they are known and trusted.
- Examine recent changes or activities performed by the user account to identify any unauthorized or suspicious actions that may indicate privilege escalation or lateral movement.
- Correlate the special logon events with other security alerts or logs, such as failed login attempts or changes in user permissions, to gather additional context and evidence of potential malicious activity.


### False positive analysis

- Regular administrative tasks by IT staff can trigger spikes in special logon events. To manage this, create exceptions for known administrative accounts that frequently perform legitimate privileged actions.
- Scheduled automated processes or scripts that require elevated access may cause false positives. Identify these processes and exclude them from the detection rule to prevent unnecessary alerts.
- Software updates or system maintenance activities often involve multiple privileged logons. Document these events and adjust the detection thresholds temporarily during known maintenance windows to reduce false positives.
- Users with roles that inherently require frequent privileged access, such as system administrators or security personnel, may trigger alerts. Maintain a list of such roles and apply exclusions where appropriate to avoid constant alerts for expected behavior.


### Response and remediation

- Immediately isolate the affected user account to prevent further unauthorized access. Disable the account or change its credentials to stop any ongoing malicious activity.
- Conduct a thorough review of recent activities associated with the affected account to identify any unauthorized changes or access to sensitive systems and data.
- If lateral movement is suspected, isolate any systems accessed by the compromised account to prevent further spread of the threat.
- Escalate the incident to the security operations center (SOC) or incident response team for a detailed investigation and to determine the full scope of the breach.
- Implement additional monitoring on the affected systems and accounts to detect any further suspicious activities or attempts to regain access.
- Review and update access controls and permissions to ensure that only necessary privileges are granted, reducing the risk of privilege escalation.
- Enhance detection capabilities by tuning existing monitoring tools to better identify similar spikes in special logon events, leveraging insights from the current incident.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Exploitation for Privilege Escalation
- Id: T1068
- Reference URL: [[https://attack.mitre.org/techniques/T1068/](https://attack.mitre.org/techniques/T1068/)](https://attack.mitre.org/techniques/T1068/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)