﻿---
title: High Command Line Entropy Detected for Privileged Commands
description: A machine learning job has identified an unusually high median command line entropy for privileged commands executed by a user, suggesting possible privileged...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_linux_high_median_process_command_line_entropy_by_user
products:
  - Elastic Security
---

# High Command Line Entropy Detected for Privileged Commands
A machine learning job has identified an unusually high median command line entropy for privileged commands executed by
a user, suggesting possible privileged access activity through command lines. High entropy often indicates that the
commands may be obfuscated or deliberately complex, which can be a sign of suspicious or unauthorized use of privileged
access.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-3h`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/pad](https://docs.elastic.co/en/integrations/pad)](https://docs.elastic.co/en/integrations/pad)

**Tags**:
- Use Case: Privileged Access Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Privileged Access Detection integration assets to be installed, as well as Linux logs collected by integrations such as Elastic Defend and Sysmon Linux.

### Privileged Access Detection Setup

The Privileged Access Detection integration detects privileged access activity by identifying abnormalities in Windows, Linux and Okta events. Anomalies are detected using Elastic's Anomaly Detection feature.

#### Prerequisite Requirements:

- Fleet is required for Privileged Access Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- Linux events collected by [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint) or [Sysmon Linux](https://docs.elastic.co/en/integrations/sysmon_linux) integration.
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To add Sysmon Linux integration to an Elastic Agent policy, refer to [this](https://www.elastic.co/guide/en/fleet/current/add-integration-to-policy.html) guide.


#### The following steps should be executed to install assets associated with the Privileged Access Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Privileged Access Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Add preconfigured anomaly detection jobs**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating High Command Line Entropy Detected for Privileged Commands

Machine learning models analyze command line inputs to identify high entropy, which may indicate obfuscation or complexity in privileged commands. Adversaries exploit this by using intricate or encoded commands to mask unauthorized activities. The detection rule leverages this analysis to flag potential privilege escalation attempts, aiding in early threat identification and response.

### Possible investigation steps

- Review the command line inputs flagged by the alert to identify any patterns or specific obfuscation techniques used.
- Cross-reference the user account associated with the alert against known valid accounts and recent access logs to determine if the activity aligns with expected behavior.
- Analyze the context of the commands executed, including the time of execution and the systems targeted, to assess the potential impact and scope of the activity.
- Check for any recent changes in user privileges or roles that might explain the execution of privileged commands.
- Investigate any related alerts or logs that might provide additional context or corroborate the suspicious activity, such as failed login attempts or unusual network connections.
- Consult with the user or relevant personnel to verify if the commands were part of legitimate administrative tasks or if they indicate unauthorized access.


### False positive analysis

- Legitimate administrative scripts may have high entropy due to complex or encoded commands. Review and whitelist these scripts to prevent unnecessary alerts.
- Automated deployment tools often use obfuscated commands for security reasons. Identify and exclude these tools from the rule to reduce false positives.
- Security software updates might execute encoded commands as part of their process. Monitor and create exceptions for these updates to avoid misclassification.
- Developers and IT staff may use complex command lines for testing or debugging. Establish a baseline of normal activity for these users and adjust the rule accordingly.
- Scheduled tasks or cron jobs with encoded commands can trigger alerts. Document and exclude these tasks if they are verified as non-threatening.


### Response and remediation

- Immediately isolate the affected system from the network to prevent further unauthorized access or lateral movement.
- Review and terminate any suspicious or unauthorized processes running under privileged accounts on the affected system.
- Reset passwords for all privileged accounts involved, ensuring they meet strong password policies to prevent unauthorized access.
- Conduct a thorough audit of recent privileged command executions to identify any unauthorized changes or data access, and revert any malicious modifications.
- Implement additional monitoring on the affected system and related accounts to detect any further suspicious activities.
- Escalate the incident to the security operations center (SOC) for a comprehensive investigation and to determine if other systems are affected.
- Update and reinforce endpoint protection measures to detect and block similar obfuscation or high-entropy command line activities in the future.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)