﻿---
title: Spike in Privileged Command Execution by a User
description: A machine learning job has detected an increase in the execution of privileged commands by a user, suggesting potential privileged access activity. This...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/pad/privileged_access_ml_linux_high_count_privileged_process_events_by_user
products:
  - Elastic Security
---

# Spike in Privileged Command Execution by a User
A machine learning job has detected an increase in the execution of privileged commands by a user, suggesting potential
privileged access activity. This may indicate an attempt by the user to gain unauthorized access to sensitive or
restricted parts of the system.
**Rule type**: machine_learning
**Rule indices**:
**Rule Severity**: low
**Risk Score**: 21
**Runs every**: 15m
**Searches indices from**: `now-3h`
**Maximum alerts per execution**: 100
**References**:
- [[https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)](https://www.elastic.co/guide/en/security/current/prebuilt-ml-jobs.html)
- [[https://docs.elastic.co/en/integrations/pad](https://docs.elastic.co/en/integrations/pad)](https://docs.elastic.co/en/integrations/pad)

**Tags**:
- Use Case: Privileged Access Detection
- Rule Type: ML
- Rule Type: Machine Learning
- Tactic: Privilege Escalation
- Resources: Investigation Guide

**Version**: 3
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Setup

The rule requires the Privileged Access Detection integration assets to be installed, as well as Linux logs collected by integrations such as Elastic Defend and Sysmon Linux.

### Privileged Access Detection Setup

The Privileged Access Detection integration detects privileged access activity by identifying abnormalities in Windows, Linux and Okta events. Anomalies are detected using Elastic's Anomaly Detection feature.

#### Prerequisite Requirements:

- Fleet is required for Privileged Access Detection.
- To configure Fleet Server refer to the [documentation](https://www.elastic.co/guide/en/fleet/current/fleet-server.html).
- Linux events collected by [Elastic Defend](https://docs.elastic.co/en/integrations/endpoint) or [Sysmon Linux](https://docs.elastic.co/en/integrations/sysmon_linux) integration.
- To install Elastic Defend, refer to the [documentation](https://www.elastic.co/guide/en/security/current/install-endpoint.html).
- To add Sysmon Linux integration to an Elastic Agent policy, refer to [this](https://www.elastic.co/guide/en/fleet/current/add-integration-to-policy.html) guide.


#### The following steps should be executed to install assets associated with the Privileged Access Detection integration:

- Go to the Kibana homepage. Under Management, click Integrations.
- In the query bar, search for Privileged Access Detection and select the integration to see more details about it.
- Follow the instructions under the **Installation** section.
- For this rule to work, complete the instructions through **Add preconfigured anomaly detection jobs**.


## Investigation guide


## Triage and analysis> **Disclaimer**:
This investigation guide was created using generative AI technology and has been reviewed to improve its accuracy and relevance. While every effort has been made to ensure its quality, we recommend validating the content and adapting it to suit your specific environment and operational needs.

### Investigating Spike in Privileged Command Execution by a User

Machine learning models are employed to monitor and analyze user behavior, specifically focusing on the execution of privileged commands. These models identify anomalies that may suggest unauthorized access attempts. Adversaries often exploit valid accounts to escalate privileges and access sensitive systems. The detection rule leverages ML to flag unusual spikes in command execution, indicating potential misuse of privileged access.

### Possible investigation steps

- Review the specific user account associated with the spike in privileged command execution to determine if the activity aligns with their typical behavior or job role.
- Analyze the timeline of the command execution spike to identify any patterns or specific times when the activity occurred, which may correlate with known maintenance windows or unusual access times.
- Cross-reference the commands executed with known privileged command lists to assess whether the commands are typical for the user's role or indicative of potential misuse.
- Check for any recent changes in the user's access rights or group memberships that might explain the increase in privileged command execution.
- Investigate any recent login activity for the user, including source IP addresses and devices, to identify any anomalies or unauthorized access attempts.
- Review any associated alerts or logs for the same user or system around the time of the spike to gather additional context or corroborating evidence of potential unauthorized access.


### False positive analysis

- Routine administrative tasks by IT staff may trigger the rule. To manage this, create exceptions for known maintenance windows or specific user accounts that regularly perform these tasks.
- Automated scripts or scheduled jobs that execute privileged commands can be mistaken for anomalies. Identify and whitelist these scripts or jobs to prevent false alerts.
- Users with newly assigned roles that require elevated privileges might cause a temporary spike in command execution. Monitor these users initially and adjust the model's sensitivity or add exceptions as needed.
- Software updates or installations that require elevated permissions can lead to false positives. Document these events and exclude them from the anomaly detection criteria.
- Training or onboarding sessions where users are learning to use new systems with privileged access can result in increased command execution. Temporarily adjust thresholds or exclude these users during the training period.


### Response and remediation

- Immediately isolate the affected user account to prevent further execution of privileged commands. This can be done by disabling the account or changing its password.
- Review recent privileged command execution logs to identify any unauthorized or suspicious activities performed by the user. Focus on commands that could alter system configurations or access sensitive data.
- Conduct a thorough investigation to determine if the user's credentials have been compromised. This may involve checking for signs of phishing attacks or unauthorized access from unusual locations or devices.
- If unauthorized access is confirmed, reset the affected user's credentials and any other accounts that may have been accessed using the compromised credentials.
- Notify the security team and relevant stakeholders about the incident, providing details of the detected anomaly and actions taken so far.
- Implement additional monitoring on the affected systems and user accounts to detect any further suspicious activities or attempts to regain unauthorized access.
- Review and update access controls and permissions to ensure that users have the minimum necessary privileges, reducing the risk of privilege escalation in the future.
  **Framework:** MITRE ATT&CK

- Tactic:
  - Name: Privilege Escalation
- Id: TA0004
- Reference URL: [[https://attack.mitre.org/tactics/TA0004/](https://attack.mitre.org/tactics/TA0004/)](https://attack.mitre.org/tactics/TA0004/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)