﻿---
title: Okta ThreatInsight Threat Suspected Promotion
description: Okta ThreatInsight is a feature that provides valuable debug data regarding authentication and authorization processes, which is logged in the system...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/okta_threatinsight_threat_suspected_promotion
products:
  - Elastic Security
---

# Okta ThreatInsight Threat Suspected Promotion
Okta ThreatInsight is a feature that provides valuable debug data regarding authentication and authorization processes,
which is logged in the system. Within this data, there is a specific field called threat_suspected, which represents
Okta's internal evaluation of the authentication or authorization workflow. When this field is set to True, it suggests
the presence of potential credential access techniques, such as password-spraying, brute-forcing, replay attacks, and
other similar threats.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-okta*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://developer.okta.com/docs/reference/api/system-log/](https://developer.okta.com/docs/reference/api/system-log/)](https://developer.okta.com/docs/reference/api/system-log/)
- [[https://developer.okta.com/docs/reference/api/event-types/](https://developer.okta.com/docs/reference/api/event-types/)](https://developer.okta.com/docs/reference/api/event-types/)
- [[https://help.okta.com/en-us/Content/Topics/Security/threat-insight/configure-threatinsight-system-log.html](https://help.okta.com/en-us/Content/Topics/Security/threat-insight/configure-threatinsight-system-log.html)](https://help.okta.com/en-us/Content/Topics/Security/threat-insight/configure-threatinsight-system-log.html)
- [[https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)
- [[https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)
- [[https://www.elastic.co/security-labs/starter-guide-to-understanding-okta](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)

**Tags**:
- Use Case: Identity and Access Audit
- Data Source: Okta
- Resources: Investigation Guide

**Version**: 412
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Setup


## Triage and analysis

This is a promotion rule for Okta ThreatInsight suspected threat events, which are alertable events per the vendor.
Consult vendor documentation on interpreting specific events.

## Rule Query

```kuery
event.dataset:okta.system and (event.action:security.threat.detected or okta.debug_context.debug_data.threat_suspected: true)
```