﻿---
title: High Number of Okta User Password Reset or Unlock Attempts
description: Identifies a high number of Okta user password reset or account unlock attempts. An adversary may attempt to obtain unauthorized access to Okta user accounts...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_suspicious_okta_user_password_reset_or_unlock_attempts
products:
  - Elastic Security
---

# High Number of Okta User Password Reset or Unlock Attempts
Identifies a high number of Okta user password reset or account unlock attempts. An adversary may attempt to obtain
unauthorized access to Okta user accounts using these methods and attempt to blend in with normal activity in their
target's environment and evade detection.
**Rule type**: threshold
**Rule indices**:
- filebeat-*
- logs-okta*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-60m`
**Maximum alerts per execution**: 100
**References**:
- [[https://developer.okta.com/docs/reference/api/system-log/](https://developer.okta.com/docs/reference/api/system-log/)](https://developer.okta.com/docs/reference/api/system-log/)
- [[https://developer.okta.com/docs/reference/api/event-types/](https://developer.okta.com/docs/reference/api/event-types/)](https://developer.okta.com/docs/reference/api/event-types/)
- [[https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)
- [[https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)
- [[https://www.elastic.co/security-labs/starter-guide-to-understanding-okta](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)

**Tags**:
- Use Case: Identity and Access Audit
- Data Source: Okta
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 415
**Rule authors**:
- Elastic
- @BenB196
- Austin Songer

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating High Number of Okta User Password Reset or Unlock Attempts

This rule is designed to detect a suspiciously high number of password reset or account unlock attempts in Okta. Excessive password resets or account unlocks can be indicative of an attacker's attempt to gain unauthorized access to an account.

#### Possible investigation steps:

- Identify the actor associated with the excessive attempts. The `okta.actor.alternate_id` field can be used for this purpose.
- Determine the client used by the actor. You can look at `okta.client.device`, `okta.client.ip`, `okta.client.user_agent.raw_user_agent`, `okta.client.ip_chain.ip`, and `okta.client.geographical_context`.
- Review the `okta.outcome.result` and `okta.outcome.reason` fields to understand the outcome of the password reset or unlock attempts.
- Review the event actions associated with these attempts. Look at the `event.action` field and filter for actions related to password reset and account unlock attempts.
- Check for other similar patterns of behavior from the same actor or IP address. If there is a high number of failed login attempts before the password reset or unlock attempts, this may suggest a brute force attack.
- Also, look at the times when these attempts were made. If these were made during off-hours, it could further suggest an adversary's activity.


### False positive analysis:

- This alert might be a false positive if there are legitimate reasons for a high number of password reset or unlock attempts. This could be due to the user forgetting their password or account lockouts due to too many incorrect attempts.
- Check the actor's past behavior. If this is their usual behavior and they have a valid reason for it, then it might be a false positive.


### Response and remediation:

- If unauthorized attempts are confirmed, initiate the incident response process.
- Reset the user's password and enforce MFA re-enrollment, if applicable.
- Block the IP address or device used in the attempts, if they appear suspicious.
- If the attack was facilitated by a particular technique, ensure your systems are patched or configured to prevent such techniques.
- Consider a security review of your Okta policies and rules to ensure they follow security best practices.


## Setup

The Okta Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:okta.system and
  event.action:(system.email.account_unlock.sent_message or system.email.password_reset.sent_message or
                system.sms.send_account_unlock_message or system.sms.send_password_reset_message or
                system.voice.send_account_unlock_call or system.voice.send_password_reset_call or
                user.account.unlock_token)
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Persistence
- Id: TA0003
- Reference URL: [[https://attack.mitre.org/tactics/TA0003/](https://attack.mitre.org/tactics/TA0003/)](https://attack.mitre.org/tactics/TA0003/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Initial Access
- Id: TA0001
- Reference URL: [[https://attack.mitre.org/tactics/TA0001/](https://attack.mitre.org/tactics/TA0001/)](https://attack.mitre.org/tactics/TA0001/)
- Technique:
  - Name: Valid Accounts
- Id: T1078
- Reference URL: [[https://attack.mitre.org/techniques/T1078/](https://attack.mitre.org/techniques/T1078/)](https://attack.mitre.org/techniques/T1078/)