﻿---
title: Attempt to Delete an Okta Network Zone
description: Detects attempts to delete an Okta network zone. Okta network zones can be configured to limit or restrict access to a network based on IP addresses or...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/defense_evasion_attempt_to_delete_okta_network_zone
products:
  - Elastic Security
---

# Attempt to Delete an Okta Network Zone
Detects attempts to delete an Okta network zone. Okta network zones can be configured to limit or restrict access to a
network based on IP addresses or geolocations. An adversary may attempt to modify, delete, or deactivate an Okta network
zone in order to remove or weaken an organization's security controls.
**Rule type**: query
**Rule indices**:
- filebeat-*
- logs-okta*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: ``
**Maximum alerts per execution**: 100
**References**:
- [[https://help.okta.com/en/prod/Content/Topics/Security/network/network-zones.htm](https://help.okta.com/en/prod/Content/Topics/Security/network/network-zones.htm)](https://help.okta.com/en/prod/Content/Topics/Security/network/network-zones.htm)
- [[https://developer.okta.com/docs/reference/api/system-log/](https://developer.okta.com/docs/reference/api/system-log/)](https://developer.okta.com/docs/reference/api/system-log/)
- [[https://developer.okta.com/docs/reference/api/event-types/](https://developer.okta.com/docs/reference/api/event-types/)](https://developer.okta.com/docs/reference/api/event-types/)
- [[https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)
- [[https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)
- [[https://www.elastic.co/security-labs/starter-guide-to-understanding-okta](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)

**Tags**:
- Use Case: Identity and Access Audit
- Data Source: Okta
- Use Case: Network Security Monitoring
- Tactic: Defense Evasion
- Resources: Investigation Guide

**Version**: 413
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2

## Investigation guide


## Triage and analysis


### Investigating Attempt to Delete an Okta Network Zone

Okta network zones can be configured to limit or restrict access to a network based on IP addresses or geolocations. Deleting a network zone in Okta might remove or weaken the security controls of an organization, which might be an indicator of an adversary's attempt to evade defenses.

#### Possible investigation steps:

- Identify the actor associated with the alert by examining the `okta.actor.id`, `okta.actor.type`, `okta.actor.alternate_id`, or `okta.actor.display_name` fields.
- Examine the `event.action` field to confirm the deletion of a network zone.
- Investigate the `okta.target.id`, `okta.target.type`, `okta.target.alternate_id`, or `okta.target.display_name` fields to identify the network zone that was deleted.
- Review the `event.time` field to understand when the event happened.
- Check the actor's activities before and after the event to understand the context of this event.


### False positive analysis:

- Verify the `okta.client.user_agent.raw_user_agent` field to understand the device and software used by the actor. If these match the actor's typical behavior, it might be a false positive.
- Check if the actor is a known administrator or a member of the IT team who might have a legitimate reason to delete a network zone.
- Cross-verify the actor's actions with any known planned changes or maintenance activities.


### Response and remediation:

- If unauthorized access or actions are confirmed, immediately lock the affected actor's account and require a password change.
- If a network zone was deleted without authorization, create a new network zone with similar settings as the deleted one.
- Review and update the privileges of the actor who initiated the deletion.
- Identify any gaps in the security policies and procedures and update them as necessary.
- Implement additional monitoring and logging of Okta events to improve visibility of user actions.
- Communicate and train the employees about the importance of following proper procedures for modifying network zone settings.


## Setup

The Okta Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Rule Query

```kuery
event.dataset:okta.system and event.action:zone.delete
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Defense Evasion
- Id: TA0005
- Reference URL: [[https://attack.mitre.org/tactics/TA0005/](https://attack.mitre.org/tactics/TA0005/)](https://attack.mitre.org/tactics/TA0005/)
- Technique:
  - Name: Impair Defenses
- Id: T1562
- Reference URL: [[https://attack.mitre.org/techniques/T1562/](https://attack.mitre.org/techniques/T1562/)](https://attack.mitre.org/techniques/T1562/)
- Sub Technique:
  - Name: Disable or Modify Cloud Firewall
- Id: T1562.007
- Reference URL: [[https://attack.mitre.org/techniques/T1562/007/](https://attack.mitre.org/techniques/T1562/007/)](https://attack.mitre.org/techniques/T1562/007/)