﻿---
title: Multiple Okta User Auth Events with Same Device Token Hash Behind a Proxy
description: Detects when Okta user authentication events are reported for multiple users with the same device token hash behind a proxy. Rule type: threshold Rule...
url: https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/integrations/okta/credential_access_multiple_auth_events_from_single_device_behind_proxy
products:
  - Elastic Security
---

# Multiple Okta User Auth Events with Same Device Token Hash Behind a Proxy
Detects when Okta user authentication events are reported for multiple users with the same device token hash behind a
proxy.
**Rule type**: threshold
**Rule indices**:
- logs-okta*

**Rule Severity**: medium
**Risk Score**: 47
**Runs every**: 
**Searches indices from**: `now-9m`
**Maximum alerts per execution**: 100
**References**:
- [[https://developer.okta.com/docs/reference/api/system-log/](https://developer.okta.com/docs/reference/api/system-log/)](https://developer.okta.com/docs/reference/api/system-log/)
- [[https://developer.okta.com/docs/reference/api/event-types/](https://developer.okta.com/docs/reference/api/event-types/)](https://developer.okta.com/docs/reference/api/event-types/)
- [[https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)](https://www.elastic.co/security-labs/testing-okta-visibility-and-detection-dorothy)
- [[https://sec.okta.com/articles/2023/08/cross-tenant-impersonation-prevention-and-detection](https://sec.okta.com/articles/2023/08/cross-tenant-impersonation-prevention-and-detection)](https://sec.okta.com/articles/2023/08/cross-tenant-impersonation-prevention-and-detection)
- [[https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)](https://www.elastic.co/security-labs/monitoring-okta-threats-with-elastic-security)
- [[https://www.elastic.co/security-labs/starter-guide-to-understanding-okta](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)](https://www.elastic.co/security-labs/starter-guide-to-understanding-okta)

**Tags**:
- Use Case: Identity and Access Audit
- Data Source: Okta
- Tactic: Credential Access
- Resources: Investigation Guide

**Version**: 210
**Rule authors**:
- Elastic

**Rule license**: Elastic License v2
The Okta Fleet integration, Filebeat module, or similarly structured data is required to be compatible with this rule.

## Investigation guide


## Triage and analysis


### Investigating Multiple Okta User Auth Events with Same Device Token Hash Behind a Proxy

This rule detects when Okta user authentication events are reported for multiple users with the same device token hash behind a proxy. This may indicate that a shared device between users, or that a user is using a proxy to access multiple accounts for password spraying.

#### Possible investigation steps:

- Identify the users involved in this action by examining the `okta.actor.id`, `okta.actor.type`, `okta.actor.alternate_id`, and `okta.actor.display_name` fields.
- Determine the device client used for these actions by analyzing `okta.client.ip`, `okta.client.user_agent.raw_user_agent`, `okta.client.zone`, `okta.client.device`, and `okta.client.id` fields.
  - Since the device is behind a proxy, the `okta.client.ip` field will not be useful for determining the actual device IP address.
- Review the `okta.request.ip_chain` field for more information about the geographic location of the proxy.
- With Okta end users identified, review the `okta.debug_context.debug_data.dt_hash` field.
  - Historical analysis should indicate if this device token hash is commonly associated with the user.
- Review the `okta.event_type` field to determine the type of authentication event that occurred.
  - If the event type is `user.authentication.sso`, the user may have legitimately started a session via a proxy for security or privacy reasons.
- If the event type is `user.authentication.password`, the user may be using a proxy to access multiple accounts for password spraying.
- Examine the `okta.outcome.result` field to determine if the authentication was successful.
- Review the past activities of the actor(s) involved in this action by checking their previous actions.
- Evaluate the actions that happened just before and after this event in the `okta.event_type` field to help understand the full context of the activity.
  - This may help determine the authentication and authorization actions that occurred between the user, Okta and application.


### False positive analysis:

- A user may have legitimately started a session via a proxy for security or privacy reasons.
- Users may share an endpoint related to work or personal use in which separate Okta accounts are used.
  - Architecturally, this shared endpoint may leverage a proxy for security or privacy reasons.
- Shared systems such as Kiosks and conference room computers may be used by multiple users.
- Shared working spaces may have a single endpoint that is used by multiple users.


### Response and remediation:

- Review the profile of the users involved in this action to determine if proxy usage may be expected.
- If the user is legitimate and the authentication behavior is not suspicious based on device analysis, no action is required.
- If the user is legitimate but the authentication behavior is suspicious, consider resetting passwords for the users involves and enabling multi-factor authentication (MFA).
  - If MFA is already enabled, consider resetting MFA for the users.
- If any of the users are not legitimate, consider deactivating the user's account.
- Conduct a review of Okta policies and ensure they are in accordance with security best practices.
- Check with internal IT teams to determine if the accounts involved recently had MFA reset at the request of the user.
  - If so, confirm with the user this was a legitimate request.
- If so and this was not a legitimate request, consider deactivating the user's account temporarily.
  - Reset passwords and reset MFA for the user.
- If this is a false positive, consider adding the `okta.debug_context.debug_data.dt_hash` field to the `exceptions` list in the rule.
  - This will prevent future occurrences of this event for this device from triggering the rule.


## Rule Query

```kuery
event.dataset:okta.system
    and not okta.actor.id:okta* and okta.debug_context.debug_data.dt_hash:*
    and okta.event_type:user.authentication* and okta.security_context.is_proxy:true
```

**Framework:** MITRE ATT&CK
- Tactic:
  - Name: Credential Access
- Id: TA0006
- Reference URL: [[https://attack.mitre.org/tactics/TA0006/](https://attack.mitre.org/tactics/TA0006/)](https://attack.mitre.org/tactics/TA0006/)
- Technique:
  - Name: Brute Force
- Id: T1110
- Reference URL: [[https://attack.mitre.org/techniques/T1110/](https://attack.mitre.org/techniques/T1110/)](https://attack.mitre.org/techniques/T1110/)
- Sub Technique:
  - Name: Password Spraying
- Id: T1110.003
- Reference URL: [[https://attack.mitre.org/techniques/T1110/003/](https://attack.mitre.org/techniques/T1110/003/)](https://attack.mitre.org/techniques/T1110/003/)
- Technique:
  - Name: Brute Force
- Id: T1110
- Reference URL: [[https://attack.mitre.org/techniques/T1110/](https://attack.mitre.org/techniques/T1110/)](https://attack.mitre.org/techniques/T1110/)
- Sub Technique:
  - Name: Credential Stuffing
- Id: T1110.004
- Reference URL: [[https://attack.mitre.org/techniques/T1110/004/](https://attack.mitre.org/techniques/T1110/004/)](https://attack.mitre.org/techniques/T1110/004/)